/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AccumulatorOperators;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class ArithmeticOperators {
    public static ArithmeticOperatorFactory valueOf(String fieldReference) {
        return new ArithmeticOperatorFactory(fieldReference);
    }

    public static ArithmeticOperatorFactory valueOf(AggregationExpression expression) {
        return new ArithmeticOperatorFactory(expression);
    }

    public static class Round
    extends AbstractAggregationExpression {
        private Round(Object value) {
            super(value);
        }

        public static Round roundValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Round(Collections.singletonList(Fields.field(fieldReference)));
        }

        public static Round roundValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Round(Collections.singletonList(expression));
        }

        public static Round round(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Round(Collections.singletonList(value));
        }

        public Round place(int place) {
            return new Round(this.append(place));
        }

        public Round placeOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Round(this.append(expression));
        }

        public Round placeOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"fieldReference must not be null!");
            return new Round(this.append(Fields.field(fieldReference)));
        }

        @Override
        protected String getMongoMethod() {
            return "$round";
        }
    }

    public static class Trunc
    extends AbstractAggregationExpression {
        private Trunc(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$trunc";
        }

        public static Trunc truncValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Trunc(Fields.field(fieldReference));
        }

        public static Trunc truncValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Trunc(expression);
        }

        public static Trunc truncValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Trunc(value);
        }
    }

    public static class Subtract
    extends AbstractAggregationExpression {
        private Subtract(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$subtract";
        }

        public static Subtract valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Subtract(Subtract.asFields(fieldReference));
        }

        public static Subtract valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Subtract(Collections.singletonList(expression));
        }

        public static Subtract valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Subtract(Collections.singletonList(value));
        }

        public Subtract subtract(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Subtract(this.append(Fields.field(fieldReference)));
        }

        public Subtract subtract(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Subtract(this.append(expression));
        }

        public Subtract subtract(Number value) {
            return new Subtract(this.append(value));
        }
    }

    public static class Sqrt
    extends AbstractAggregationExpression {
        private Sqrt(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sqrt";
        }

        public static Sqrt sqrtOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Sqrt(Fields.field(fieldReference));
        }

        public static Sqrt sqrtOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Sqrt(expression);
        }

        public static Sqrt sqrtOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Sqrt(value);
        }
    }

    public static class Pow
    extends AbstractAggregationExpression {
        private Pow(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$pow";
        }

        public static Pow valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Pow(Pow.asFields(fieldReference));
        }

        public static Pow valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Pow(Collections.singletonList(expression));
        }

        public static Pow valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Pow(Collections.singletonList(value));
        }

        public Pow pow(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Pow(this.append(Fields.field(fieldReference)));
        }

        public Pow pow(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Pow(this.append(expression));
        }

        public Pow pow(Number value) {
            return new Pow(this.append(value));
        }
    }

    public static class Multiply
    extends AbstractAggregationExpression {
        private Multiply(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$multiply";
        }

        public static Multiply valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Multiply(Multiply.asFields(fieldReference));
        }

        public static Multiply valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Multiply(Collections.singletonList(expression));
        }

        public static Multiply valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Multiply(Collections.singletonList(value));
        }

        public Multiply multiplyBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Multiply(this.append(Fields.field(fieldReference)));
        }

        public Multiply multiplyBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Multiply(this.append(expression));
        }

        public Multiply multiplyBy(Number value) {
            return new Multiply(this.append(value));
        }
    }

    public static class Mod
    extends AbstractAggregationExpression {
        private Mod(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$mod";
        }

        public static Mod valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Mod(Mod.asFields(fieldReference));
        }

        public static Mod valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Mod(Collections.singletonList(expression));
        }

        public static Mod valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Mod(Collections.singletonList(value));
        }

        public Mod mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Mod(this.append(Fields.field(fieldReference)));
        }

        public Mod mod(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Mod(this.append(expression));
        }

        public Mod mod(Number base) {
            return new Mod(this.append(base));
        }
    }

    public static class Log10
    extends AbstractAggregationExpression {
        private Log10(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$log10";
        }

        public static Log10 log10ValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Log10(Fields.field(fieldReference));
        }

        public static Log10 log10ValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Log10(expression);
        }

        public static Log10 log10ValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Log10(value);
        }
    }

    public static class Log
    extends AbstractAggregationExpression {
        private Log(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$log";
        }

        public static Log valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Log(Log.asFields(fieldReference));
        }

        public static Log valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Log(Collections.singletonList(expression));
        }

        public static Log valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Log(Collections.singletonList(value));
        }

        public Log log(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Log(this.append(Fields.field(fieldReference)));
        }

        public Log log(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Log(this.append(expression));
        }

        public Log log(Number base) {
            return new Log(this.append(base));
        }
    }

    public static class Ln
    extends AbstractAggregationExpression {
        private Ln(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$ln";
        }

        public static Ln lnValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Ln(Fields.field(fieldReference));
        }

        public static Ln lnValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Ln(expression);
        }

        public static Ln lnValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Ln(value);
        }
    }

    public static class Floor
    extends AbstractAggregationExpression {
        private Floor(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$floor";
        }

        public static Floor floorValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Floor(Fields.field(fieldReference));
        }

        public static Floor floorValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Floor(expression);
        }

        public static Floor floorValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Floor(value);
        }
    }

    public static class Exp
    extends AbstractAggregationExpression {
        private Exp(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$exp";
        }

        public static Exp expValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Exp(Fields.field(fieldReference));
        }

        public static Exp expValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Exp(expression);
        }

        public static Exp expValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Exp(value);
        }
    }

    public static class Divide
    extends AbstractAggregationExpression {
        private Divide(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$divide";
        }

        public static Divide valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Divide(Divide.asFields(fieldReference));
        }

        public static Divide valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Divide(Collections.singletonList(expression));
        }

        public static Divide valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Divide(Collections.singletonList(value));
        }

        public Divide divideBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Divide(this.append(Fields.field(fieldReference)));
        }

        public Divide divideBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Divide(this.append(expression));
        }

        public Divide divideBy(Number value) {
            return new Divide(this.append(value));
        }
    }

    public static class Ceil
    extends AbstractAggregationExpression {
        private Ceil(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$ceil";
        }

        public static Ceil ceilValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Ceil(Fields.field(fieldReference));
        }

        public static Ceil ceilValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Ceil(expression);
        }

        public static Ceil ceilValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Ceil(value);
        }
    }

    public static class Add
    extends AbstractAggregationExpression {
        protected Add(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$add";
        }

        public static Add valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Add(Add.asFields(fieldReference));
        }

        public static Add valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Add(Collections.singletonList(expression));
        }

        public static Add valueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Add(Collections.singletonList(value));
        }

        public Add add(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Add(this.append(Fields.field(fieldReference)));
        }

        public Add add(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Add(this.append(expression));
        }

        public Add add(Number value) {
            return new Add(this.append(value));
        }
    }

    public static class Abs
    extends AbstractAggregationExpression {
        private Abs(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$abs";
        }

        public static Abs absoluteValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Abs(Fields.field(fieldReference));
        }

        public static Abs absoluteValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Abs(expression);
        }

        public static Abs absoluteValueOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Abs(value);
        }
    }

    public static class ArithmeticOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public ArithmeticOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public ArithmeticOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Abs abs() {
            return this.usesFieldRef() ? Abs.absoluteValueOf(this.fieldReference) : Abs.absoluteValueOf(this.expression);
        }

        public Add add(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createAdd().add(fieldReference);
        }

        public Add add(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createAdd().add(expression);
        }

        public Add add(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createAdd().add(value);
        }

        private Add createAdd() {
            return this.usesFieldRef() ? Add.valueOf(this.fieldReference) : Add.valueOf(this.expression);
        }

        public Ceil ceil() {
            return this.usesFieldRef() ? Ceil.ceilValueOf(this.fieldReference) : Ceil.ceilValueOf(this.expression);
        }

        public Divide divideBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createDivide().divideBy(fieldReference);
        }

        public Divide divideBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createDivide().divideBy(expression);
        }

        public Divide divideBy(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createDivide().divideBy(value);
        }

        private Divide createDivide() {
            return this.usesFieldRef() ? Divide.valueOf(this.fieldReference) : Divide.valueOf(this.expression);
        }

        public Exp exp() {
            return this.usesFieldRef() ? Exp.expValueOf(this.fieldReference) : Exp.expValueOf(this.expression);
        }

        public Floor floor() {
            return this.usesFieldRef() ? Floor.floorValueOf(this.fieldReference) : Floor.floorValueOf(this.expression);
        }

        public Ln ln() {
            return this.usesFieldRef() ? Ln.lnValueOf(this.fieldReference) : Ln.lnValueOf(this.expression);
        }

        public Log log(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createLog().log(fieldReference);
        }

        public Log log(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createLog().log(this.fieldReference);
        }

        public Log log(Number base) {
            Assert.notNull((Object)base, (String)"Base must not be null!");
            return this.createLog().log(base);
        }

        private Log createLog() {
            return this.usesFieldRef() ? Log.valueOf(this.fieldReference) : Log.valueOf(this.expression);
        }

        public Log10 log10() {
            return this.usesFieldRef() ? Log10.log10ValueOf(this.fieldReference) : Log10.log10ValueOf(this.expression);
        }

        public Mod mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createMod().mod(fieldReference);
        }

        public Mod mod(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createMod().mod(expression);
        }

        public Mod mod(Number value) {
            Assert.notNull((Object)value, (String)"Base must not be null!");
            return this.createMod().mod(value);
        }

        private Mod createMod() {
            return this.usesFieldRef() ? Mod.valueOf(this.fieldReference) : Mod.valueOf(this.expression);
        }

        public Multiply multiplyBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createMultiply().multiplyBy(fieldReference);
        }

        public Multiply multiplyBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createMultiply().multiplyBy(expression);
        }

        public Multiply multiplyBy(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createMultiply().multiplyBy(value);
        }

        private Multiply createMultiply() {
            return this.usesFieldRef() ? Multiply.valueOf(this.fieldReference) : Multiply.valueOf(this.expression);
        }

        public Pow pow(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createPow().pow(fieldReference);
        }

        public Pow pow(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createPow().pow(expression);
        }

        public Pow pow(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createPow().pow(value);
        }

        private Pow createPow() {
            return this.usesFieldRef() ? Pow.valueOf(this.fieldReference) : Pow.valueOf(this.expression);
        }

        public Sqrt sqrt() {
            return this.usesFieldRef() ? Sqrt.sqrtOf(this.fieldReference) : Sqrt.sqrtOf(this.expression);
        }

        public Subtract subtract(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createSubtract().subtract(fieldReference);
        }

        public Subtract subtract(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createSubtract().subtract(expression);
        }

        public Subtract subtract(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createSubtract().subtract(value);
        }

        private Subtract createSubtract() {
            return this.usesFieldRef() ? Subtract.valueOf(this.fieldReference) : Subtract.valueOf(this.expression);
        }

        public Trunc trunc() {
            return this.usesFieldRef() ? Trunc.truncValueOf(this.fieldReference) : Trunc.truncValueOf(this.expression);
        }

        public AccumulatorOperators.Sum sum() {
            return this.usesFieldRef() ? AccumulatorOperators.Sum.sumOf(this.fieldReference) : AccumulatorOperators.Sum.sumOf(this.expression);
        }

        public AccumulatorOperators.Avg avg() {
            return this.usesFieldRef() ? AccumulatorOperators.Avg.avgOf(this.fieldReference) : AccumulatorOperators.Avg.avgOf(this.expression);
        }

        public AccumulatorOperators.Max max() {
            return this.usesFieldRef() ? AccumulatorOperators.Max.maxOf(this.fieldReference) : AccumulatorOperators.Max.maxOf(this.expression);
        }

        public AccumulatorOperators.Min min() {
            return this.usesFieldRef() ? AccumulatorOperators.Min.minOf(this.fieldReference) : AccumulatorOperators.Min.minOf(this.expression);
        }

        public AccumulatorOperators.StdDevPop stdDevPop() {
            return this.usesFieldRef() ? AccumulatorOperators.StdDevPop.stdDevPopOf(this.fieldReference) : AccumulatorOperators.StdDevPop.stdDevPopOf(this.expression);
        }

        public AccumulatorOperators.StdDevSamp stdDevSamp() {
            return this.usesFieldRef() ? AccumulatorOperators.StdDevSamp.stdDevSampOf(this.fieldReference) : AccumulatorOperators.StdDevSamp.stdDevSampOf(this.expression);
        }

        public Round round() {
            return this.usesFieldRef() ? Round.roundValueOf(this.fieldReference) : Round.roundValueOf(this.expression);
        }

        public Round roundToPlace(int place) {
            return this.round().place(place);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

