/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class AbstractAggregationExpression
implements AggregationExpression {
    private final Object value;

    protected AbstractAggregationExpression(Object value) {
        this.value = value;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return this.toDocument(this.value, context);
    }

    public Document toDocument(Object value, AggregationOperationContext context) {
        return new Document(this.getMongoMethod(), this.unpack(value, context));
    }

    protected static List<Field> asFields(String ... fieldRefs) {
        if (ObjectUtils.isEmpty((Object[])fieldRefs)) {
            return Collections.emptyList();
        }
        return Fields.fields(fieldRefs).asList();
    }

    private Object unpack(Object value, AggregationOperationContext context) {
        if (value instanceof AggregationExpression) {
            return ((AggregationExpression)value).toDocument(context);
        }
        if (value instanceof Field) {
            return context.getReference((Field)value).toString();
        }
        if (value instanceof List) {
            List sourceList = (List)value;
            ArrayList mappedList = new ArrayList(sourceList.size());
            sourceList.stream().map(item -> this.unpack(item, context)).forEach(mappedList::add);
            return mappedList;
        }
        if (value instanceof Map) {
            Document targetDocument = new Document();
            Map sourceMap = (Map)value;
            sourceMap.forEach((k, v) -> targetDocument.append(k, this.unpack(v, context)));
            return targetDocument;
        }
        if (value instanceof Aggregation.SystemVariable) {
            return value.toString();
        }
        return value;
    }

    protected List<Object> append(Object value, Expand expandList) {
        if (this.value instanceof List) {
            ArrayList<Object> clone = new ArrayList<Object>((List)this.value);
            if (value instanceof Collection && Expand.EXPAND_VALUES.equals((Object)expandList)) {
                clone.addAll((Collection)value);
            } else {
                clone.add(value);
            }
            return clone;
        }
        return Arrays.asList(this.value, value);
    }

    protected List<Object> append(Object value) {
        return this.append(value, Expand.EXPAND_VALUES);
    }

    protected Map<String, Object> append(String key, Object value) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        LinkedHashMap<String, Object> clone = new LinkedHashMap<String, Object>((Map)this.value);
        clone.put(key, value);
        return clone;
    }

    protected List<Object> values() {
        if (this.value instanceof List) {
            return new ArrayList<Object>((List)this.value);
        }
        if (this.value instanceof Map) {
            return new ArrayList<Object>(((Map)this.value).values());
        }
        return new ArrayList<Object>(Collections.singletonList(this.value));
    }

    protected <T> T get(int index) {
        return (T)this.values().get(index);
    }

    protected <T> T get(Object key) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        return (T)((Map)this.value).get(key);
    }

    protected Map<String, Object> argumentMap() {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        return Collections.unmodifiableMap((Map)this.value);
    }

    protected boolean contains(Object key) {
        if (!(this.value instanceof Map)) {
            return false;
        }
        return ((Map)this.value).containsKey(key);
    }

    protected abstract String getMongoMethod();

    protected static enum Expand {
        EXPAND_VALUES,
        KEEP_SOURCE;

    }
}

