/*
 * Copyright 2015-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;

/**
 * Default {@link WriteConcernResolver} resolving the {@link WriteConcern} from the given {@link MongoAction}.
 *
 * @author Oliver Gierke
 */
enum DefaultWriteConcernResolver implements WriteConcernResolver {

	INSTANCE;

	public WriteConcern resolve(MongoAction action) {
		return action.getDefaultWriteConcern();
	}
}
