/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.repository.Meta;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.Tailable;
import org.springframework.data.mongodb.repository.query.MongoEntityMetadata;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.SimpleMongoEntityMetadata;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoQueryMethod
extends QueryMethod {
    private static final List<Class<? extends Serializable>> GEO_NEAR_RESULTS = Arrays.asList(GeoResult.class, GeoResults.class, GeoPage.class);
    private final Method method;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    @Nullable
    private MongoEntityMetadata<?> metadata;

    public MongoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.method = method;
        this.mappingContext = mappingContext;
    }

    protected MongoParameters createParameters(Method method) {
        return new MongoParameters(method, this.isGeoNearQuery(method));
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    @Nullable
    String getAnnotatedQuery() {
        return this.findAnnotatedQuery().orElse(null);
    }

    private Optional<String> findAnnotatedQuery() {
        return Optional.ofNullable(this.getQueryAnnotation()).map(AnnotationUtils::getValue).map(it -> (String)it).filter(StringUtils::hasText);
    }

    String getFieldSpecification() {
        return Optional.ofNullable(this.getQueryAnnotation()).map(it -> (String)AnnotationUtils.getValue((Annotation)it, (String)"fields")).filter(StringUtils::hasText).orElse(null);
    }

    public MongoEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleMongoEntityMetadata(domainClass, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                MongoPersistentEntity returnedEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                MongoPersistentEntity managedEntity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                MongoPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleMongoEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.metadata;
    }

    public MongoParameters getParameters() {
        return (MongoParameters)super.getParameters();
    }

    public boolean isGeoNearQuery() {
        return this.isGeoNearQuery(this.method);
    }

    private boolean isGeoNearQuery(Method method) {
        Class<?> returnType = method.getReturnType();
        for (Class<? extends Serializable> type : GEO_NEAR_RESULTS) {
            if (!type.isAssignableFrom(returnType)) continue;
            return true;
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            TypeInformation from = ClassTypeInformation.fromReturnTypeOf((Method)method);
            return GeoResult.class.equals((Object)from.getRequiredComponentType().getType());
        }
        return false;
    }

    @Nullable
    Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasQueryMetaAttributes() {
        return this.getMetaAnnotation() != null;
    }

    @Nullable
    Meta getMetaAnnotation() {
        return (Meta)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Meta.class);
    }

    @Nullable
    Tailable getTailableAnnotation() {
        return (Tailable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Tailable.class);
    }

    public org.springframework.data.mongodb.core.query.Meta getQueryMetaAttributes() {
        Meta meta = this.getMetaAnnotation();
        if (meta == null) {
            return new org.springframework.data.mongodb.core.query.Meta();
        }
        org.springframework.data.mongodb.core.query.Meta metaAttributes = new org.springframework.data.mongodb.core.query.Meta();
        if (meta.maxExecutionTimeMs() > 0L) {
            metaAttributes.setMaxTimeMsec(meta.maxExecutionTimeMs());
        }
        if (meta.maxScanDocuments() > 0L) {
            metaAttributes.setMaxScan(meta.maxScanDocuments());
        }
        if (StringUtils.hasText((String)meta.comment())) {
            metaAttributes.setComment(meta.comment());
        }
        if (meta.snapshot()) {
            metaAttributes.setSnapshot(meta.snapshot());
        }
        if (!ObjectUtils.isEmpty((Object[])meta.flags())) {
            for (Meta.CursorOption option : meta.flags()) {
                metaAttributes.addFlag(option);
            }
        }
        return metaAttributes;
    }
}

