/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.reactivestreams.client.FindPublisher;
import lombok.NonNull;
import org.bson.Document;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.mongodb.core.FindPublisherPreparer;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveFindOperationSupport
implements ReactiveFindOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final ReactiveMongoTemplate template;

    @Override
    public <T> ReactiveFindOperation.ReactiveFind<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveFindSupport<T>(this.template, domainType, domainType, null, ALL_QUERY);
    }

    public ReactiveFindOperationSupport(@NonNull ReactiveMongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        this.template = template;
    }

    static class ReactiveFindSupport<T>
    implements ReactiveFindOperation.ReactiveFind<T>,
    ReactiveFindOperation.FindWithCollection<T>,
    ReactiveFindOperation.FindWithProjection<T>,
    ReactiveFindOperation.FindWithQuery<T> {
        @NonNull
        private final ReactiveMongoTemplate template;
        @NonNull
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String collection;
        private final Query query;

        @Override
        public ReactiveFindOperation.FindWithProjection<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection name must not be null nor empty!");
            return new ReactiveFindSupport<T>(this.template, this.domainType, this.returnType, collection, this.query);
        }

        @Override
        public <T1> ReactiveFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null!");
            return new ReactiveFindSupport<T1>(this.template, this.domainType, returnType, this.collection, this.query);
        }

        @Override
        public ReactiveFindOperation.TerminatingFind<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ReactiveFindSupport<T>(this.template, this.domainType, this.returnType, this.collection, query);
        }

        @Override
        public Mono<T> first() {
            final FindPublisherPreparer preparer = this.getCursorPreparer(this.query);
            Flux<T> result = this.doFind(new FindPublisherPreparer(){

                public <D> FindPublisher<D> prepare(FindPublisher<D> publisher) {
                    return preparer.prepare(publisher).limit(1);
                }
            });
            return result.next();
        }

        @Override
        public Mono<T> one() {
            final FindPublisherPreparer preparer = this.getCursorPreparer(this.query);
            Flux<T> result = this.doFind(new FindPublisherPreparer(){

                public <D> FindPublisher<D> prepare(FindPublisher<D> publisher) {
                    return preparer.prepare(publisher).limit(2);
                }
            });
            return result.collectList().flatMap(it -> {
                if (it.isEmpty()) {
                    return Mono.empty();
                }
                if (it.size() > 1) {
                    return Mono.error((Throwable)new IncorrectResultSizeDataAccessException("Query " + this.asString() + " returned non unique result.", 1));
                }
                return Mono.just(it.get(0));
            });
        }

        @Override
        public Flux<T> all() {
            return this.doFind(null);
        }

        @Override
        public ReactiveFindOperation.TerminatingFindNear<T> near(NearQuery nearQuery) {
            return () -> this.template.geoNear(nearQuery, this.domainType, this.getCollectionName(), this.returnType);
        }

        @Override
        public Mono<Long> count() {
            return this.template.count(this.query, this.domainType, this.getCollectionName());
        }

        @Override
        public Mono<Boolean> exists() {
            return this.template.exists(this.query, this.domainType, this.getCollectionName());
        }

        private Flux<T> doFind(@Nullable FindPublisherPreparer preparer) {
            Document queryObject = this.query.getQueryObject();
            Document fieldsObject = this.query.getFieldsObject();
            return this.template.doFind(this.getCollectionName(), queryObject, fieldsObject, this.domainType, this.returnType, preparer != null ? preparer : this.getCursorPreparer(this.query));
        }

        private FindPublisherPreparer getCursorPreparer(Query query) {
            ReactiveMongoTemplate reactiveMongoTemplate = this.template;
            reactiveMongoTemplate.getClass();
            return reactiveMongoTemplate.new ReactiveMongoTemplate.QueryFindPublisherPreparer(query, this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        private String asString() {
            return SerializationUtils.serializeToJsonSafely(this.query);
        }

        public ReactiveFindSupport(@NonNull ReactiveMongoTemplate template, @NonNull Class<?> domainType, Class<T> returnType, String collection, Query query) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
        }
    }
}

