/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.lang.Nullable;

public class BsonUtils {
    @Nullable
    public static <T> T get(Bson bson, String key) {
        return (T)BsonUtils.asMap(bson).get(key);
    }

    public static Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof BasicDBObject) {
            return (BasicDBObject)bson;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot read values from " + bson.getClass());
    }

    public static void addToMap(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).put(key, value);
            return;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot add value to " + bson.getClass());
    }
}

