/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.util.JSON;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.bson.BsonWriter;
import org.bson.codecs.BinaryCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonWriter;
import org.bson.types.Binary;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider evaluationContextProvider;
    private final CodecRegistry codecRegistry;

    public ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.codecRegistry = MongoClient.getDefaultCodecRegistry();
    }

    public String bind(String raw, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!StringUtils.hasText((String)raw)) {
            return raw;
        }
        return this.replacePlaceholders(raw, accessor, bindingContext);
    }

    private String replacePlaceholders(String input, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!bindingContext.hasBindings()) {
            return input;
        }
        if (input.matches("^\\?\\d+$")) {
            return this.getParameterValueForBinding(accessor, bindingContext.getParameters(), bindingContext.getBindings().iterator().next());
        }
        Matcher matcher = this.createReplacementPattern(bindingContext.getBindings()).matcher(input);
        StringBuffer buffer = new StringBuffer();
        int parameterIndex = 0;
        while (matcher.find()) {
            Placeholder placeholder = this.extractPlaceholder(parameterIndex++, matcher);
            StringBasedMongoQuery.ParameterBinding binding = bindingContext.getBindingFor(placeholder);
            String valueForBinding = this.getParameterValueForBinding(accessor, bindingContext.getParameters(), binding);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(valueForBinding));
            if (StringUtils.hasText((String)placeholder.getSuffix())) {
                buffer.append(placeholder.getSuffix());
            }
            if (!placeholder.isQuoted()) continue;
            this.postProcessQuotedBinding(buffer, valueForBinding, !binding.isExpression() ? accessor.getBindableValue(binding.getParameterIndex()) : null, binding.isExpression());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private void postProcessQuotedBinding(StringBuffer buffer, String valueForBinding, @Nullable Object raw, boolean isExpression) {
        int quotationMarkIndex = buffer.length() - valueForBinding.length() - 1;
        char quotationMark = buffer.charAt(quotationMarkIndex);
        while (quotationMark != '\'' && quotationMark != '\"') {
            if (--quotationMarkIndex < 0) {
                throw new IllegalArgumentException("Could not find opening quotes for quoted parameter");
            }
            quotationMark = buffer.charAt(quotationMarkIndex);
        }
        if (valueForBinding.startsWith("{") && (raw instanceof DBObject || isExpression)) {
            buffer.deleteCharAt(quotationMarkIndex);
        } else {
            if (isExpression) {
                buffer.deleteCharAt(quotationMarkIndex);
                return;
            }
            if (quotationMark == '\'') {
                buffer.replace(quotationMarkIndex, quotationMarkIndex + 1, "\"");
            }
            buffer.append("\"");
        }
    }

    private String getParameterValueForBinding(MongoParameterAccessor accessor, MongoParameters parameters, StringBasedMongoQuery.ParameterBinding binding) {
        Object value;
        Object object = value = binding.isExpression() ? this.evaluateExpression(binding.getExpression(), parameters, accessor.getValues()) : accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            if (binding.isExpression() && ((String)value).startsWith("{")) {
                return (String)value;
            }
            return binding.isExpression() ? JSON.serialize((Object)value) : QuotedString.unquote(JSON.serialize((Object)value));
        }
        return EncodableValue.create(value).encode(this.codecRegistry, binding.isQuoted());
    }

    @Nullable
    private Object evaluateExpression(String expressionString, MongoParameters parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    private Pattern createReplacementPattern(List<StringBasedMongoQuery.ParameterBinding> bindings) {
        StringBuilder regex = new StringBuilder();
        for (StringBasedMongoQuery.ParameterBinding binding : bindings) {
            regex.append("|");
            regex.append("(" + Pattern.quote(binding.getParameter()) + ")");
            regex.append("([\\w.]*");
            regex.append("(\\W?['\"]|\\w*')?)");
        }
        return Pattern.compile(regex.substring(1));
    }

    private Placeholder extractPlaceholder(int parameterIndex, Matcher matcher) {
        String rawPlaceholder = matcher.group(parameterIndex * 3 + 1);
        String suffix = matcher.group(parameterIndex * 3 + 2);
        if (!StringUtils.hasText((String)rawPlaceholder)) {
            rawPlaceholder = matcher.group();
            if (rawPlaceholder.matches(".*\\d$")) {
                suffix = "";
            } else {
                int index = rawPlaceholder.replaceAll("[^\\?0-9]*$", "").length() - 1;
                if (index > 0 && rawPlaceholder.length() > index) {
                    suffix = rawPlaceholder.substring(index + 1);
                }
            }
            if (QuotedString.endsWithQuote(rawPlaceholder)) {
                rawPlaceholder = rawPlaceholder.substring(0, rawPlaceholder.length() - (StringUtils.hasText((String)suffix) ? suffix.length() : 1));
            }
        }
        if (StringUtils.hasText((String)suffix)) {
            boolean quoted;
            return Placeholder.of(parameterIndex, rawPlaceholder, quoted, (quoted = QuotedString.endsWithQuote(suffix)) ? QuotedString.unquoteSuffix(suffix) : suffix);
        }
        return Placeholder.of(parameterIndex, rawPlaceholder, false, null);
    }

    static class ObjectValue
    extends EncodableValue {
        @Nullable
        private final Object value;

        @Override
        public String encode(CodecRegistry codecRegistry, boolean quoted) {
            return JSON.serialize((Object)this.value);
        }

        public ObjectValue(@Nullable Object value) {
            this.value = value;
        }
    }

    static class UuidCollection
    extends EncodableValue {
        private final Collection<UUID> value;

        @Override
        public String encode(CodecRegistry codecRegistry, boolean quoted) {
            return this.encodeCollection(codecRegistry, this.value, Function.identity(), UuidCodec::new);
        }

        public UuidCollection(Collection<UUID> value) {
            this.value = value;
        }
    }

    static class UuidValue
    extends EncodableValue {
        private final UUID value;

        @Override
        public String encode(CodecRegistry codecRegistry, boolean quoted) {
            if (quoted) {
                return this.value.toString();
            }
            return this.encode(codecRegistry, this.value, UuidCodec::new);
        }

        public UuidValue(UUID value) {
            this.value = value;
        }
    }

    static class BinaryCollectionValue
    extends EncodableValue {
        private final Collection<byte[]> value;

        @Override
        public String encode(CodecRegistry codecRegistry, boolean quoted) {
            return this.encodeCollection(codecRegistry, this.value, Binary::new, BinaryCodec::new);
        }

        public BinaryCollectionValue(Collection<byte[]> value) {
            this.value = value;
        }
    }

    static class BinaryValue
    extends EncodableValue {
        private final byte[] value;

        @Override
        public String encode(CodecRegistry codecRegistry, boolean quoted) {
            if (quoted) {
                return DatatypeConverter.printBase64Binary((byte[])this.value);
            }
            return this.encode(codecRegistry, new Binary(this.value), BinaryCodec::new);
        }

        public BinaryValue(byte[] value) {
            this.value = value;
        }
    }

    static abstract class EncodableValue {
        EncodableValue() {
        }

        public static EncodableValue create(@Nullable Object value) {
            Collection collection;
            Class commonElement;
            if (value instanceof byte[]) {
                return new BinaryValue((byte[])value);
            }
            if (value instanceof UUID) {
                return new UuidValue((UUID)value);
            }
            if (value instanceof Collection && (commonElement = CollectionUtils.findCommonElementType((Collection)(collection = (Collection)value))) != null) {
                if (UUID.class.isAssignableFrom(commonElement)) {
                    return new UuidCollection((Collection)value);
                }
                if (byte[].class.isAssignableFrom(commonElement)) {
                    return new BinaryCollectionValue((Collection)value);
                }
            }
            return new ObjectValue(value);
        }

        public abstract String encode(CodecRegistry var1, boolean var2);

        protected <V> String encode(CodecRegistry codecRegistry, V value, Supplier<Codec<V>> defaultCodec) {
            StringWriter writer = new StringWriter();
            this.doEncode(codecRegistry, writer, value, defaultCodec);
            return writer.toString();
        }

        protected <I, V> String encodeCollection(CodecRegistry codecRegistry, Iterable<I> value, Function<I, V> mappingFunction, Supplier<Codec<V>> defaultCodec) {
            StringWriter writer = new StringWriter();
            writer.append("[");
            value.forEach(it -> {
                if (writer.getBuffer().length() > 1) {
                    writer.append(", ");
                }
                this.doEncode(codecRegistry, writer, mappingFunction.apply(it), defaultCodec);
            });
            writer.append("]");
            writer.flush();
            return writer.toString();
        }

        private <V> void doEncode(CodecRegistry codecRegistry, StringWriter writer, V value, Supplier<Codec<V>> defaultCodec) {
            Codec<?> codec = this.getCodec(codecRegistry, value.getClass(), defaultCodec);
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            codec.encode((BsonWriter)jsonWriter, value, null);
            jsonWriter.flush();
        }

        private <T> Codec<T> getCodec(CodecRegistry codecRegistry, Class<T> type, Supplier<Codec<T>> defaultCodec) {
            try {
                return codecRegistry.get(type);
            }
            catch (CodecConfigurationException exception) {
                return defaultCodec.get();
            }
        }
    }

    static final class QuotedString {
        static boolean endsWithQuote(String string) {
            return string.endsWith("'") || string.endsWith("\"");
        }

        public static String unquoteSuffix(String quoted) {
            return quoted.substring(0, quoted.length() - 1);
        }

        public static String unquote(String quoted) {
            return quoted.substring(1, quoted.length() - 1);
        }

        private QuotedString() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    static final class Placeholder {
        private final int parameterIndex;
        private final String parameter;
        private final boolean quoted;
        @Nullable
        private final String suffix;

        public String toString() {
            return this.quoted ? String.format("'%s'", this.parameter + (this.suffix != null ? this.suffix : "")) : this.parameter + (this.suffix != null ? this.suffix : "");
        }

        private Placeholder(int parameterIndex, String parameter, boolean quoted, @Nullable String suffix) {
            this.parameterIndex = parameterIndex;
            this.parameter = parameter;
            this.quoted = quoted;
            this.suffix = suffix;
        }

        public static Placeholder of(int parameterIndex, String parameter, boolean quoted, @Nullable String suffix) {
            return new Placeholder(parameterIndex, parameter, quoted, suffix);
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getParameter() {
            return this.parameter;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        @Nullable
        public String getSuffix() {
            return this.suffix;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder other = (Placeholder)o;
            if (this.getParameterIndex() != other.getParameterIndex()) {
                return false;
            }
            String this$parameter = this.getParameter();
            String other$parameter = other.getParameter();
            return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getParameterIndex();
            String $parameter = this.getParameter();
            result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
            return result;
        }
    }

    static class BindingContext {
        final MongoParameters parameters;
        final Map<Placeholder, StringBasedMongoQuery.ParameterBinding> bindings;

        public BindingContext(MongoParameters parameters, List<StringBasedMongoQuery.ParameterBinding> bindings) {
            this.parameters = parameters;
            this.bindings = BindingContext.mapBindings(bindings);
        }

        boolean hasBindings() {
            return !CollectionUtils.isEmpty(this.bindings);
        }

        public List<StringBasedMongoQuery.ParameterBinding> getBindings() {
            return new ArrayList<StringBasedMongoQuery.ParameterBinding>(this.bindings.values());
        }

        StringBasedMongoQuery.ParameterBinding getBindingFor(Placeholder placeholder) {
            if (!this.bindings.containsKey(placeholder)) {
                throw new NoSuchElementException(String.format("Could not to find binding for placeholder '%s'.", placeholder));
            }
            return this.bindings.get(placeholder);
        }

        public MongoParameters getParameters() {
            return this.parameters;
        }

        private static Map<Placeholder, StringBasedMongoQuery.ParameterBinding> mapBindings(List<StringBasedMongoQuery.ParameterBinding> bindings) {
            LinkedHashMap<Placeholder, StringBasedMongoQuery.ParameterBinding> map = new LinkedHashMap<Placeholder, StringBasedMongoQuery.ParameterBinding>(bindings.size(), 1.0f);
            int parameterIndex = 0;
            for (StringBasedMongoQuery.ParameterBinding binding : bindings) {
                map.put(Placeholder.of(parameterIndex++, binding.getParameter(), binding.isQuoted(), null), binding);
            }
            return map;
        }
    }
}

