/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import java.util.Optional;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;

public interface ExecutableUpdateOperation {
    public <T> ExecutableUpdate<T> update(Class<T> var1);

    public static interface ExecutableUpdate<T>
    extends UpdateWithCollection<T>,
    UpdateWithQuery<T>,
    UpdateWithUpdate<T> {
    }

    public static interface TerminatingUpdate<T>
    extends TerminatingFindAndModify<T>,
    FindAndModifyWithOptions<T> {
        public UpdateResult all();

        public UpdateResult first();

        public UpdateResult upsert();
    }

    public static interface TerminatingFindAndModify<T> {
        default public Optional<T> findAndModify() {
            return Optional.ofNullable(this.findAndModifyValue());
        }

        @Nullable
        public T findAndModifyValue();
    }

    public static interface FindAndModifyWithOptions<T> {
        public TerminatingFindAndModify<T> withOptions(FindAndModifyOptions var1);
    }

    public static interface UpdateWithQuery<T>
    extends UpdateWithUpdate<T> {
        public UpdateWithUpdate<T> matching(Query var1);
    }

    public static interface UpdateWithCollection<T> {
        public UpdateWithQuery<T> inCollection(String var1);
    }

    public static interface UpdateWithUpdate<T> {
        public TerminatingUpdate<T> apply(Update var1);
    }
}

