/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import com.mongodb.DBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.mapping.event.AbstractDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;

public abstract class AbstractMongoEventListener<E>
implements ApplicationListener<MongoMappingEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMongoEventListener.class);
    private final Class<?> domainClass;

    public AbstractMongoEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractMongoEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(MongoMappingEvent<?> event) {
        if (event instanceof AfterLoadEvent) {
            AfterLoadEvent afterLoadEvent = (AfterLoadEvent)event;
            if (this.domainClass.isAssignableFrom(afterLoadEvent.getType())) {
                this.onAfterLoad((AfterLoadEvent)event);
            }
            return;
        }
        if (event instanceof AbstractDeleteEvent) {
            Class eventDomainType = ((AbstractDeleteEvent)event).getType();
            if (eventDomainType != null && this.domainClass.isAssignableFrom(eventDomainType)) {
                if (event instanceof BeforeDeleteEvent) {
                    this.onBeforeDelete((BeforeDeleteEvent)event);
                }
                if (event instanceof AfterDeleteEvent) {
                    this.onAfterDelete((AfterDeleteEvent)event);
                }
            }
            return;
        }
        Object source = event.getSource();
        if (source != null && !this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof BeforeConvertEvent) {
            this.onBeforeConvert((BeforeConvertEvent)event);
        } else if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave((BeforeSaveEvent)event);
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave((AfterSaveEvent)event);
        } else if (event instanceof AfterConvertEvent) {
            this.onAfterConvert((AfterConvertEvent)event);
        }
    }

    @Deprecated
    public void onBeforeConvert(E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeConvert({})", source);
        }
    }

    public void onBeforeConvert(BeforeConvertEvent<E> event) {
        this.onBeforeConvert(event.getSource());
    }

    @Deprecated
    public void onBeforeSave(E source, DBObject dbo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeSave({}, {})", source, (Object)dbo);
        }
    }

    public void onBeforeSave(BeforeSaveEvent<E> event) {
        this.onBeforeSave(event.getSource(), event.getDBObject());
    }

    @Deprecated
    public void onAfterSave(E source, DBObject dbo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterSave({}, {})", source, (Object)dbo);
        }
    }

    public void onAfterSave(AfterSaveEvent<E> event) {
        this.onAfterSave(event.getSource(), event.getDBObject());
    }

    @Deprecated
    public void onAfterLoad(DBObject dbo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterLoad({})", (Object)dbo);
        }
    }

    public void onAfterLoad(AfterLoadEvent<E> event) {
        this.onAfterLoad(event.getDBObject());
    }

    @Deprecated
    public void onAfterConvert(DBObject dbo, E source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterConvert({}, {})", (Object)dbo, source);
        }
    }

    public void onAfterConvert(AfterConvertEvent<E> event) {
        this.onAfterConvert(event.getDBObject(), event.getSource());
    }

    @Deprecated
    public void onAfterDelete(DBObject dbo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterDelete({})", (Object)dbo);
        }
    }

    public void onAfterDelete(AfterDeleteEvent<E> event) {
        this.onAfterDelete(event.getDBObject());
    }

    @Deprecated
    public void onBeforeDelete(DBObject dbo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeDelete({})", (Object)dbo);
        }
    }

    public void onBeforeDelete(BeforeDeleteEvent<E> event) {
        this.onBeforeDelete(event.getDBObject());
    }
}

