/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import java.util.regex.Pattern;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

class SpringDataMongodbSerializer
extends MongodbSerializer {
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public SpringDataMongodbSerializer(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.mappingContext = converter.getMappingContext();
        this.converter = converter;
        this.mapper = new QueryMapper(converter);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata<?> metadata) {
        if (!metadata.getPathType().equals((Object)PathType.PROPERTY)) {
            return super.getKeyForPath(expr, metadata);
        }
        Path parent = metadata.getParent();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(metadata.getName());
        return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
    }

    protected DBObject asDBObject(String key, Object value) {
        if ("_id".equals(key)) {
            return super.asDBObject(key, this.mapper.convertId(value));
        }
        return super.asDBObject(key, value instanceof Pattern ? value : this.converter.convertToMongoType(value));
    }
}

