/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DB;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultDbRefResolver
implements DbRefResolver {
    private static final boolean OBJENESIS_PRESENT = ClassUtils.isPresent((String)"org.objenesis.Objenesis", null);
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public DefaultDbRefResolver(MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
    }

    @Override
    public Object resolveDbRef(MongoPersistentProperty property, com.mongodb.DBRef dbref, DbRefResolverCallback callback) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        Assert.notNull((Object)callback, (String)"Callback must not be null!");
        if (this.isLazyDbRef(property)) {
            return this.createLazyLoadingProxy(property, dbref, callback);
        }
        return callback.resolve(property);
    }

    @Override
    public com.mongodb.DBRef createDbRef(DBRef annotation, MongoPersistentEntity<?> entity, Object id) {
        DB db = this.mongoDbFactory.getDb();
        db = annotation != null && StringUtils.hasText((String)annotation.db()) ? this.mongoDbFactory.getDb(annotation.db()) : db;
        return new com.mongodb.DBRef(db, entity.getCollection(), id);
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, com.mongodb.DBRef dbref, DbRefResolverCallback callback) {
        ProxyFactory proxyFactory = new ProxyFactory();
        Class propertyType = property.getType();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, dbref, this.exceptionTranslator, callback);
        proxyFactory.addInterface(LazyLoadingProxy.class);
        if (propertyType.isInterface()) {
            proxyFactory.addInterface(propertyType);
            proxyFactory.addAdvice((Advice)interceptor);
            return proxyFactory.getProxy();
        }
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setTargetClass(propertyType);
        if (!OBJENESIS_PRESENT) {
            proxyFactory.addAdvice((Advice)interceptor);
            return proxyFactory.getProxy();
        }
        return ObjenesisProxyEnhancer.enhanceAndGet(proxyFactory, propertyType, interceptor);
    }

    private boolean isLazyDbRef(MongoPersistentProperty property) {
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    private static class ObjenesisProxyEnhancer {
        private static final boolean IS_SPRING_4_OR_BETTER = ClassUtils.isPresent((String)"org.springframework.core.DefaultParameterNameDiscoverer", null);
        private static final InstanceCreatorStrategy INSTANCE_CREATOR = IS_SPRING_4_OR_BETTER ? new Spring4ObjenesisInstanceCreatorStrategy() : new DefaultObjenesisInstanceCreatorStrategy();

        private ObjenesisProxyEnhancer() {
        }

        public static Object enhanceAndGet(ProxyFactory proxyFactory, Class<?> type, MethodInterceptor interceptor) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setCallbackType(MethodInterceptor.class);
            enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
            Factory factory = (Factory)INSTANCE_CREATOR.newInstance(enhancer.createClass());
            factory.setCallbacks(new Callback[]{interceptor});
            return factory;
        }

        private static class Spring4ObjenesisInstanceCreatorStrategy
        implements InstanceCreatorStrategy {
            private static final String SPRING4_OBJENESIS_CLASS_NAME = "org.springframework.objenesis.ObjenesisStd";
            private static final Object OBJENESIS;
            private static final Method NEW_INSTANCE_METHOD;

            private Spring4ObjenesisInstanceCreatorStrategy() {
            }

            @Override
            public Object newInstance(Class<?> clazz) {
                try {
                    return NEW_INSTANCE_METHOD.invoke(OBJENESIS, clazz);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not created instance for " + clazz, e);
                }
            }

            static {
                try {
                    Class objenesisClass = ClassUtils.forName((String)SPRING4_OBJENESIS_CLASS_NAME, (ClassLoader)ObjenesisProxyEnhancer.class.getClassLoader());
                    OBJENESIS = BeanUtils.instantiateClass(objenesisClass.getConstructor(Boolean.TYPE), (Object[])new Object[]{true});
                    NEW_INSTANCE_METHOD = objenesisClass.getMethod("newInstance", Class.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not setup Objenesis infrastructure with Spring 4 ", e);
                }
            }
        }

        private static class DefaultObjenesisInstanceCreatorStrategy
        implements InstanceCreatorStrategy {
            private static final Objenesis OBJENESIS = new ObjenesisStd(true);

            private DefaultObjenesisInstanceCreatorStrategy() {
            }

            @Override
            public Object newInstance(Class<?> clazz) {
                return OBJENESIS.newInstance(clazz);
            }
        }

        static interface InstanceCreatorStrategy {
            public Object newInstance(Class<?> var1);
        }
    }

    static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private static final Method INITIALIZE_METHOD;
        private static final Method TO_DBREF_METHOD;
        private final DbRefResolverCallback callback;
        private final MongoPersistentProperty property;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        private Object result;
        private com.mongodb.DBRef dbref;

        public LazyLoadingInterceptor(MongoPersistentProperty property, com.mongodb.DBRef dbref, PersistenceExceptionTranslator exceptionTranslator, DbRefResolverCallback callback) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            Assert.notNull((Object)exceptionTranslator, (String)"Exception translator must not be null!");
            Assert.notNull((Object)callback, (String)"Callback must not be null!");
            this.dbref = dbref;
            this.callback = callback;
            this.exceptionTranslator = exceptionTranslator;
            this.property = property;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object target;
            if (INITIALIZE_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (TO_DBREF_METHOD.equals(method)) {
                return this.dbref;
            }
            if (ReflectionUtils.isObjectMethod((Method)method) && Object.class.equals(method.getDeclaringClass())) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString(proxy);
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return this.proxyEquals(proxy, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return this.proxyHashCode(proxy);
                }
            }
            if ((target = this.ensureResolved()) == null) {
                return null;
            }
            return method.invoke(target, args);
        }

        private String proxyToString(Object proxy) {
            StringBuilder description = new StringBuilder();
            if (this.dbref != null) {
                description.append(this.dbref.getRef());
                description.append(":");
                description.append(this.dbref.getId());
            } else {
                description.append(System.identityHashCode(proxy));
            }
            description.append("$").append(LazyLoadingProxy.class.getSimpleName());
            return description.toString();
        }

        private int proxyHashCode(Object proxy) {
            return this.proxyToString(proxy).hashCode();
        }

        private boolean proxyEquals(Object proxy, Object that) {
            if (!(that instanceof LazyLoadingProxy)) {
                return false;
            }
            if (that == proxy) {
                return true;
            }
            return this.proxyToString(proxy).equals(that.toString());
        }

        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        private synchronized Object resolve() {
            if (!this.resolved) {
                try {
                    return this.callback.resolve(this.property);
                }
                catch (RuntimeException ex) {
                    DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                    throw new LazyLoadingException("Unable to lazily resolve DBRef!", (Throwable)translatedException);
                }
            }
            return this.result;
        }

        static {
            try {
                INITIALIZE_METHOD = LazyLoadingProxy.class.getMethod("initialize", new Class[0]);
                TO_DBREF_METHOD = LazyLoadingProxy.class.getMethod("toDBRef", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

