/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoPersistentEntityIndexCreator
implements ApplicationListener<MappingContextEvent<MongoPersistentEntity<?>, MongoPersistentProperty>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final MongoDbFactory mongoDbFactory;
    private final MongoMappingContext mappingContext;

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull((Object)((Object)mappingContext));
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
        for (BasicMongoPersistentEntity entity : mappingContext.getPersistentEntities()) {
            this.checkForIndexes(entity);
        }
    }

    public void onApplicationEvent(MappingContextEvent<MongoPersistentEntity<?>, MongoPersistentProperty> event) {
        if (!event.wasEmittedBy((MappingContext)this.mappingContext)) {
            return;
        }
        PersistentEntity entity = event.getPersistentEntity();
        if (entity instanceof MongoPersistentEntity) {
            this.checkForIndexes((MongoPersistentEntity)event.getPersistentEntity());
        }
    }

    protected void checkForIndexes(final MongoPersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzing class " + type + " for index information.");
            }
            if (type.isAnnotationPresent(CompoundIndexes.class)) {
                CompoundIndexes indexes = type.getAnnotation(CompoundIndexes.class);
                for (CompoundIndex index : indexes.value()) {
                    String indexColl = StringUtils.hasText((String)index.collection()) ? index.collection() : entity.getCollection();
                    DBObject definition = (DBObject)JSON.parse((String)index.def());
                    this.ensureIndex(indexColl, index.name(), definition, index.unique(), index.dropDups(), index.sparse(), index.background(), index.expireAfterSeconds());
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Created compound index " + index);
                }
            }
            entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

                public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                    Field field = persistentProperty.getField();
                    if (field.isAnnotationPresent(Indexed.class)) {
                        Indexed index = field.getAnnotation(Indexed.class);
                        String name = index.name();
                        if (!StringUtils.hasText((String)name)) {
                            name = persistentProperty.getFieldName();
                        } else if (!name.equals(field.getName()) && index.unique() && !index.sparse() && LOGGER.isWarnEnabled()) {
                            LOGGER.warn("The index name " + name + " doesn't match this property name: " + field.getName() + ". Setting sparse=true on this index will prevent errors when inserting documents.");
                        }
                        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : entity.getCollection();
                        int direction = index.direction() == IndexDirection.ASCENDING ? 1 : -1;
                        BasicDBObject definition = new BasicDBObject(persistentProperty.getFieldName(), (Object)direction);
                        MongoPersistentEntityIndexCreator.this.ensureIndex(collection, name, (DBObject)definition, index.unique(), index.dropDups(), index.sparse(), index.background(), index.expireAfterSeconds());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Created property index " + index);
                        }
                    } else if (field.isAnnotationPresent(GeoSpatialIndexed.class)) {
                        GeoSpatialIndexed index = field.getAnnotation(GeoSpatialIndexed.class);
                        GeospatialIndex indexObject = new GeospatialIndex(persistentProperty.getFieldName());
                        indexObject.withMin(index.min()).withMax(index.max());
                        indexObject.named(StringUtils.hasText((String)index.name()) ? index.name() : field.getName());
                        indexObject.typed(index.type()).withBucketSize(index.bucketSize()).withAdditionalField(index.additionalField());
                        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : entity.getCollection();
                        MongoPersistentEntityIndexCreator.this.mongoDbFactory.getDb().getCollection(collection).ensureIndex(indexObject.getIndexKeys(), indexObject.getIndexOptions());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("Created %s for entity %s in collection %s! ", indexObject, entity.getType(), collection));
                        }
                    }
                }
            });
            this.classesSeen.put(type, true);
        }
    }

    public boolean isIndexCreatorFor(MappingContext<?, ?> context) {
        return ((Object)((Object)this.mappingContext)).equals(context);
    }

    protected void ensureIndex(String collection, String name, DBObject indexDefinition, boolean unique, boolean dropDups, boolean sparse, boolean background, int expireAfterSeconds) {
        BasicDBObject opts = new BasicDBObject();
        opts.put("name", (Object)name);
        opts.put("dropDups", (Object)dropDups);
        opts.put("sparse", (Object)sparse);
        opts.put("unique", (Object)unique);
        opts.put("background", (Object)background);
        if (expireAfterSeconds != -1) {
            opts.put("expireAfterSeconds", (Object)expireAfterSeconds);
        }
        this.mongoDbFactory.getDb().getCollection(collection).ensureIndex(indexDefinition, (DBObject)opts);
    }
}

