/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.DBObject;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

public class TypeBasedAggregationOperationContext
implements AggregationOperationContext {
    private final Class<?> type;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public TypeBasedAggregationOperationContext(Class<?> type, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, QueryMapper mapper) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        Assert.notNull((Object)mapper, (String)"QueryMapper must not be null!");
        this.type = type;
        this.mappingContext = mappingContext;
        this.mapper = mapper;
    }

    @Override
    public DBObject getMappedObject(DBObject dbObject) {
        return this.mapper.getMappedObject(dbObject, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(this.type));
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        PropertyPath.from((String)field.getTarget(), this.type);
        return this.getReferenceFor(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        PersistentPropertyPath propertyPath = this.mappingContext.getPersistentPropertyPath(name, this.type);
        return this.getReferenceFor(Fields.field(((MongoPersistentProperty)propertyPath.getLeafProperty()).getName(), propertyPath.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE)));
    }

    private ExposedFields.FieldReference getReferenceFor(Field field) {
        return new ExposedFields.FieldReference(new ExposedFields.ExposedField(field, true));
    }
}

