/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.aggregation.AggregationExpressionTransformer;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.data.mongodb.core.spel.ExpressionTransformationContextSupport;
import org.springframework.data.mongodb.core.spel.LiteralNode;
import org.springframework.data.mongodb.core.spel.MethodReferenceNode;
import org.springframework.data.mongodb.core.spel.OperatorNode;
import org.springframework.data.mongodb.util.DBObjectUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.ast.CompoundExpression;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

class SpelExpressionTransformer
implements AggregationExpressionTransformer {
    private static final SpelParserConfiguration CONFIG = new SpelParserConfiguration(false, false);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser(CONFIG);
    private final List<ExpressionNodeConversion<? extends ExpressionNode>> conversions;

    public SpelExpressionTransformer() {
        ArrayList<ExpressionNodeConversion> conversions = new ArrayList<ExpressionNodeConversion>();
        conversions.add(new OperatorNodeConversion(this));
        conversions.add(new LiteralNodeConversion(this));
        conversions.add(new IndexerNodeConversion(this));
        conversions.add(new InlineListNodeConversion(this));
        conversions.add(new PropertyOrFieldReferenceNodeConversion(this));
        conversions.add(new CompoundExpressionNodeConversion(this));
        conversions.add(new MethodReferenceNodeConversion(this));
        this.conversions = Collections.unmodifiableList(conversions);
    }

    public Object transform(String expression, AggregationOperationContext context, Object ... params) {
        Assert.notNull((Object)expression, (String)"Expression must not be null!");
        Assert.notNull((Object)context, (String)"AggregationOperationContext must not be null!");
        Assert.notNull((Object)params, (String)"Parameters must not be null!");
        SpelExpression spelExpression = (SpelExpression)PARSER.parseExpression(expression);
        ExpressionState state = new ExpressionState((EvaluationContext)new StandardEvaluationContext((Object)params), CONFIG);
        ExpressionNode node = ExpressionNode.from(spelExpression.getAST(), state);
        return this.transform(new AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode>(node, null, null, context));
    }

    @Override
    public Object transform(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
        return this.lookupConversionFor((ExpressionNode)context.getCurrentNode()).convert(context);
    }

    private ExpressionNodeConversion<ExpressionNode> lookupConversionFor(ExpressionNode node) {
        for (ExpressionNodeConversion<ExpressionNode> expressionNodeConversion : this.conversions) {
            if (!expressionNodeConversion.supports(node)) continue;
            return expressionNodeConversion;
        }
        throw new IllegalArgumentException("Unsupported Element: " + node + " Type: " + node.getClass() + " You probably have a syntax error in your SpEL expression!");
    }

    private static class CompoundExpressionNodeConversion
    extends ExpressionNodeConversion<ExpressionNode> {
        public CompoundExpressionNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
            Object currentNode = context.getCurrentNode();
            if (((ExpressionNode)currentNode).hasfirstChildNotOfType(Indexer.class)) {
                return context.getFieldReference().toString();
            }
            return context.addToPreviousOrReturn(((ExpressionNode)currentNode).getValue());
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isOfType(CompoundExpression.class);
        }
    }

    private static class MethodReferenceNodeConversion
    extends ExpressionNodeConversion<MethodReferenceNode> {
        public MethodReferenceNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<MethodReferenceNode> context) {
            MethodReferenceNode node = (MethodReferenceNode)context.getCurrentNode();
            ArrayList<Object> args = new ArrayList<Object>();
            for (ExpressionNode childNode : node) {
                args.add(this.transform(childNode, context));
            }
            return context.addToPreviousOrReturn(new BasicDBObject(node.getMethodName(), (Object)DBObjectUtils.dbList(args.toArray())));
        }
    }

    private static class LiteralNodeConversion
    extends ExpressionNodeConversion<LiteralNode> {
        public LiteralNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<LiteralNode> context) {
            LiteralNode node = (LiteralNode)context.getCurrentNode();
            Object value = node.getValue();
            if (context.hasPreviousOperation()) {
                if (node.isUnaryMinus(context.getParentNode())) {
                    return NumberUtils.convertNumberToTargetClass((Number)(((Number)value).doubleValue() * -1.0), value.getClass());
                }
                return context.addToPreviousOperation(value);
            }
            return value;
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isLiteral();
        }
    }

    private static class PropertyOrFieldReferenceNodeConversion
    extends ExpressionNodeConversion<ExpressionNode> {
        public PropertyOrFieldReferenceNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
            String fieldReference = context.getFieldReference().toString();
            return context.addToPreviousOrReturn(fieldReference);
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isOfType(PropertyOrFieldReference.class);
        }
    }

    private static class InlineListNodeConversion
    extends ExpressionNodeConversion<ExpressionNode> {
        public InlineListNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
            Object currentNode = context.getCurrentNode();
            if (!((ExpressionNode)currentNode).hasChildren()) {
                return null;
            }
            return this.transform(((ExpressionNode)currentNode).getChild(0), (ExpressionNode)currentNode, null, context);
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isOfType(InlineList.class);
        }
    }

    private static class IndexerNodeConversion
    extends ExpressionNodeConversion<ExpressionNode> {
        public IndexerNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
            return context.addToPreviousOrReturn(((ExpressionNode)context.getCurrentNode()).getValue());
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isOfType(Indexer.class);
        }
    }

    private static class OperatorNodeConversion
    extends ExpressionNodeConversion<OperatorNode> {
        public OperatorNodeConversion(AggregationExpressionTransformer transformer) {
            super(transformer);
        }

        @Override
        protected Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<OperatorNode> context) {
            OperatorNode currentNode = (OperatorNode)context.getCurrentNode();
            DBObject operationObject = this.createOperationObjectAndAddToPreviousArgumentsIfNecessary(context, currentNode);
            Object leftResult = this.transform(currentNode.getLeft(), currentNode, operationObject, context);
            if (currentNode.isUnaryMinus()) {
                return this.convertUnaryMinusOp(context, leftResult);
            }
            this.transform(currentNode.getRight(), currentNode, operationObject, context);
            return operationObject;
        }

        private DBObject createOperationObjectAndAddToPreviousArgumentsIfNecessary(AggregationExpressionTransformer.AggregationExpressionTransformationContext<OperatorNode> context, OperatorNode currentNode) {
            BasicDBObject nextDbObject = new BasicDBObject(currentNode.getMongoOperator(), (Object)new BasicDBList());
            if (!context.hasPreviousOperation()) {
                return nextDbObject;
            }
            if (context.parentIsSameOperation()) {
                nextDbObject = context.getPreviousOperationObject();
            } else if (!currentNode.isUnaryOperator()) {
                context.addToPreviousOperation(nextDbObject);
            }
            return nextDbObject;
        }

        private Object convertUnaryMinusOp(ExpressionTransformationContextSupport<OperatorNode> context, Object leftResult) {
            Object result;
            Object object = result = leftResult instanceof Number ? leftResult : new BasicDBObject("$multiply", (Object)DBObjectUtils.dbList(-1, leftResult));
            if (leftResult != null && context.hasPreviousOperation()) {
                context.addToPreviousOperation(result);
            }
            return result;
        }

        @Override
        protected boolean supports(ExpressionNode node) {
            return node.isMathematicalOperation();
        }
    }

    private static abstract class ExpressionNodeConversion<T extends ExpressionNode>
    implements AggregationExpressionTransformer {
        private final AggregationExpressionTransformer transformer;
        private final Class<? extends ExpressionNode> nodeType;

        public ExpressionNodeConversion(AggregationExpressionTransformer transformer) {
            Assert.notNull((Object)transformer, (String)"Transformer must not be null!");
            this.nodeType = GenericTypeResolver.resolveTypeArgument(this.getClass(), ExpressionNodeConversion.class);
            this.transformer = transformer;
        }

        protected boolean supports(ExpressionNode node) {
            return this.nodeType.equals(node.getClass());
        }

        protected Object transform(ExpressionNode node, AggregationExpressionTransformer.AggregationExpressionTransformationContext<?> context) {
            Assert.notNull((Object)node, (String)"ExpressionNode must not be null!");
            Assert.notNull(context, (String)"AggregationExpressionTransformationContext must not be null!");
            return this.transform(node, context.getParentNode(), null, context);
        }

        protected Object transform(ExpressionNode node, ExpressionNode parent, DBObject operation, AggregationExpressionTransformer.AggregationExpressionTransformationContext<?> context) {
            Assert.notNull((Object)node, (String)"ExpressionNode must not be null!");
            Assert.notNull(context, (String)"AggregationExpressionTransformationContext must not be null!");
            return this.transform(new AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode>(node, parent, operation, context.getAggregationContext()));
        }

        @Override
        public Object transform(AggregationExpressionTransformer.AggregationExpressionTransformationContext<ExpressionNode> context) {
            return this.transformer.transform(context);
        }

        protected abstract Object convert(AggregationExpressionTransformer.AggregationExpressionTransformationContext<T> var1);
    }
}

