/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.IndexField;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class IndexInfo {
    private static final Double ONE = 1.0;
    private static final Double MINUS_ONE = -1.0;
    private static final Collection<String> TWO_D_IDENTIFIERS = Arrays.asList("2d", "2dsphere");
    private final List<IndexField> indexFields;
    private final String name;
    private final boolean unique;
    private final boolean dropDuplicates;
    private final boolean sparse;
    private final String language;
    private String partialFilterExpression;

    @Deprecated
    public IndexInfo(List<IndexField> indexFields, String name, boolean unique, boolean dropDuplicates, boolean sparse) {
        this(indexFields, name, unique, dropDuplicates, sparse, "");
    }

    public IndexInfo(List<IndexField> indexFields, String name, boolean unique, boolean dropDuplicates, boolean sparse, String language) {
        this.indexFields = Collections.unmodifiableList(indexFields);
        this.name = name;
        this.unique = unique;
        this.dropDuplicates = dropDuplicates;
        this.sparse = sparse;
        this.language = language;
    }

    public static IndexInfo indexInfoOf(DBObject sourceDocument) {
        DBObject keyDbObject = (DBObject)sourceDocument.get("key");
        int numberOfElements = keyDbObject.keySet().size();
        ArrayList<IndexField> indexFields = new ArrayList<IndexField>(numberOfElements);
        for (String key : keyDbObject.keySet()) {
            Object value = keyDbObject.get(key);
            if (TWO_D_IDENTIFIERS.contains(value)) {
                indexFields.add(IndexField.geo(key));
                continue;
            }
            if ("text".equals(value)) {
                DBObject weights = (DBObject)sourceDocument.get("weights");
                for (String fieldName : weights.keySet()) {
                    indexFields.add(IndexField.text(fieldName, Float.valueOf(weights.get(fieldName).toString())));
                }
                continue;
            }
            Double keyValue = new Double(value.toString());
            if (ONE.equals(keyValue)) {
                indexFields.add(IndexField.create(key, Sort.Direction.ASC));
                continue;
            }
            if (!MINUS_ONE.equals(keyValue)) continue;
            indexFields.add(IndexField.create(key, Sort.Direction.DESC));
        }
        String name = sourceDocument.get("name").toString();
        boolean unique = sourceDocument.containsField("unique") ? (Boolean)sourceDocument.get("unique") : false;
        boolean dropDuplicates = sourceDocument.containsField("dropDups") ? (Boolean)sourceDocument.get("dropDups") : false;
        boolean sparse = sourceDocument.containsField("sparse") ? (Boolean)sourceDocument.get("sparse") : false;
        String language = sourceDocument.containsField("default_language") ? (String)sourceDocument.get("default_language") : "";
        String partialFilter = sourceDocument.containsField("partialFilterExpression") ? sourceDocument.get("partialFilterExpression").toString() : "";
        IndexInfo info = new IndexInfo(indexFields, name, unique, dropDuplicates, sparse, language);
        info.partialFilterExpression = partialFilter;
        return info;
    }

    public List<IndexField> getIndexFields() {
        return this.indexFields;
    }

    public boolean isIndexForFields(Collection<String> keys) {
        Assert.notNull(keys, (String)"Collection of keys must not be null!");
        ArrayList<String> indexKeys = new ArrayList<String>(this.indexFields.size());
        for (IndexField field : this.indexFields) {
            indexKeys.add(field.getKey());
        }
        return indexKeys.containsAll(keys);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isDropDuplicates() {
        return this.dropDuplicates;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public String toString() {
        return "IndexInfo [indexFields=" + this.indexFields + ", name=" + this.name + ", unique=" + this.unique + ", dropDuplicates=" + this.dropDuplicates + ", sparse=" + this.sparse + ", language=" + this.language + ", partialFilterExpression=" + this.partialFilterExpression + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dropDuplicates ? 1231 : 1237);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.indexFields);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sparse ? 1231 : 1237);
        result = 31 * result + (this.unique ? 1231 : 1237);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.language);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.partialFilterExpression);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexInfo other = (IndexInfo)obj;
        if (this.dropDuplicates != other.dropDuplicates) {
            return false;
        }
        if (this.indexFields == null ? other.indexFields != null : !this.indexFields.equals(other.indexFields)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sparse != other.sparse) {
            return false;
        }
        if (this.unique != other.unique) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.language, (Object)other.language)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.partialFilterExpression, (Object)other.partialFilterExpression);
    }
}

