/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GraphLookupOperation
implements FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private static final Set<Class<?>> ALLOWED_START_TYPES = new HashSet<Class>(Arrays.asList(AggregationExpression.class, String.class, Field.class, DBObject.class));
    private final String from;
    private final List<Object> startWith;
    private final Field connectFrom;
    private final Field connectTo;
    private final Field as;
    private final Long maxDepth;
    private final Field depthField;
    private final CriteriaDefinition restrictSearchWithMatch;

    private GraphLookupOperation(String from, List<Object> startWith, Field connectFrom, Field connectTo, Field as, Long maxDepth, Field depthField, CriteriaDefinition restrictSearchWithMatch) {
        this.from = from;
        this.startWith = startWith;
        this.connectFrom = connectFrom;
        this.connectTo = connectTo;
        this.as = as;
        this.maxDepth = maxDepth;
        this.depthField = depthField;
        this.restrictSearchWithMatch = restrictSearchWithMatch;
    }

    public static FromBuilder builder() {
        return new GraphLookupOperationFromBuilder();
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject graphLookup = new BasicDBObject();
        graphLookup.put("from", (Object)this.from);
        ArrayList<Object> mappedStartWith = new ArrayList<Object>(this.startWith.size());
        for (Object startWithElement : this.startWith) {
            if (startWithElement instanceof AggregationExpression) {
                mappedStartWith.add(((AggregationExpression)startWithElement).toDbObject(context));
                continue;
            }
            if (startWithElement instanceof Field) {
                mappedStartWith.add(context.getReference((Field)startWithElement).toString());
                continue;
            }
            mappedStartWith.add(startWithElement);
        }
        graphLookup.put("startWith", mappedStartWith.size() == 1 ? mappedStartWith.iterator().next() : mappedStartWith);
        graphLookup.put("connectFromField", (Object)this.connectFrom.getName());
        graphLookup.put("connectToField", (Object)this.connectTo.getName());
        graphLookup.put("as", (Object)this.as.getName());
        if (this.maxDepth != null) {
            graphLookup.put("maxDepth", (Object)this.maxDepth);
        }
        if (this.depthField != null) {
            graphLookup.put("depthField", (Object)this.depthField.getName());
        }
        if (this.restrictSearchWithMatch != null) {
            graphLookup.put("restrictSearchWithMatch", (Object)context.getMappedObject(this.restrictSearchWithMatch.getCriteriaObject()));
        }
        return new BasicDBObject("$graphLookup", (Object)graphLookup);
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(new ExposedFields.ExposedField(this.as, true));
    }

    static final class GraphLookupOperationBuilder {
        private final String from;
        private final List<Object> startWith;
        private final Field connectFrom;
        private final Field connectTo;
        private Long maxDepth;
        private Field depthField;
        private CriteriaDefinition restrictSearchWithMatch;

        protected GraphLookupOperationBuilder(String from, List<? extends Object> startWith, String connectFrom, String connectTo) {
            this.from = from;
            this.startWith = new ArrayList<Object>(startWith);
            this.connectFrom = Fields.field(connectFrom);
            this.connectTo = Fields.field(connectTo);
        }

        public GraphLookupOperationBuilder maxDepth(long numberOfRecursions) {
            Assert.isTrue((numberOfRecursions >= 0L ? 1 : 0) != 0, (String)"Max depth must be >= 0!");
            this.maxDepth = numberOfRecursions;
            return this;
        }

        public GraphLookupOperationBuilder depthField(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Depth field name must not be null or empty!");
            this.depthField = Fields.field(fieldName);
            return this;
        }

        public GraphLookupOperationBuilder restrict(CriteriaDefinition criteriaDefinition) {
            Assert.notNull((Object)criteriaDefinition, (String)"CriteriaDefinition must not be null!");
            this.restrictSearchWithMatch = criteriaDefinition;
            return this;
        }

        public GraphLookupOperation as(String fieldName) {
            Assert.hasText((String)fieldName, (String)"As field name must not be null or empty!");
            return new GraphLookupOperation(this.from, this.startWith, this.connectFrom, this.connectTo, Fields.field(fieldName), this.maxDepth, this.depthField, this.restrictSearchWithMatch);
        }
    }

    static final class GraphLookupOperationFromBuilder
    implements FromBuilder,
    StartWithBuilder,
    ConnectFromBuilder,
    ConnectToBuilder {
        private String from;
        private List<? extends Object> startWith;
        private String connectFrom;

        GraphLookupOperationFromBuilder() {
        }

        @Override
        public StartWithBuilder from(String collectionName) {
            Assert.hasText((String)collectionName, (String)"CollectionName must not be null or empty!");
            this.from = collectionName;
            return this;
        }

        @Override
        public ConnectFromBuilder startWith(String ... fieldReferences) {
            Assert.notNull((Object)fieldReferences, (String)"FieldReferences must not be null!");
            Assert.noNullElements((Object[])fieldReferences, (String)"FieldReferences must not contain null elements!");
            ArrayList<? extends Object> fields = new ArrayList<Object>(fieldReferences.length);
            for (String fieldReference : fieldReferences) {
                fields.add(Fields.field(fieldReference));
            }
            this.startWith = fields;
            return this;
        }

        @Override
        public ConnectFromBuilder startWith(AggregationExpression ... expressions) {
            Assert.notNull((Object)expressions, (String)"AggregationExpressions must not be null!");
            Assert.noNullElements((Object[])expressions, (String)"AggregationExpressions must not contain null elements!");
            this.startWith = Arrays.asList(expressions);
            return this;
        }

        @Override
        public ConnectFromBuilder startWith(Object ... expressions) {
            Assert.notNull((Object)expressions, (String)"Expressions must not be null!");
            Assert.noNullElements((Object[])expressions, (String)"Expressions must not contain null elements!");
            this.startWith = this.verifyAndPotentiallyTransformStartsWithTypes(expressions);
            return this;
        }

        private List<Object> verifyAndPotentiallyTransformStartsWithTypes(Object ... expressions) {
            ArrayList<Object> expressionsToUse = new ArrayList<Object>(expressions.length);
            for (Object expression : expressions) {
                this.assertStartWithType(expression);
                if (expression instanceof String) {
                    expressionsToUse.add(Fields.field((String)expression));
                    continue;
                }
                expressionsToUse.add(expression);
            }
            return expressionsToUse;
        }

        private void assertStartWithType(Object expression) {
            for (Class type : ALLOWED_START_TYPES) {
                if (!ClassUtils.isAssignable((Class)type, expression.getClass())) continue;
                return;
            }
            throw new IllegalArgumentException(String.format("Expression must be any of %s but was %s", ALLOWED_START_TYPES, expression.getClass()));
        }

        @Override
        public ConnectToBuilder connectFrom(String fieldName) {
            Assert.hasText((String)fieldName, (String)"ConnectFrom must not be null or empty!");
            this.connectFrom = fieldName;
            return this;
        }

        @Override
        public GraphLookupOperationBuilder connectTo(String fieldName) {
            Assert.hasText((String)fieldName, (String)"ConnectTo must not be null or empty!");
            return new GraphLookupOperationBuilder(this.from, this.startWith, this.connectFrom, fieldName);
        }
    }

    public static interface ConnectToBuilder {
        public GraphLookupOperationBuilder connectTo(String var1);
    }

    public static interface ConnectFromBuilder {
        public ConnectToBuilder connectFrom(String var1);
    }

    public static interface StartWithBuilder {
        public ConnectFromBuilder startWith(String ... var1);

        public ConnectFromBuilder startWith(AggregationExpression ... var1);

        public ConnectFromBuilder startWith(Object ... var1);
    }

    public static interface FromBuilder {
        public StartWithBuilder from(String var1);
    }
}

