/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.CannotGetMongoDbConnectionException;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.util.StringUtils;

@Deprecated
public class MongoFactoryBean
extends AbstractFactoryBean<Mongo>
implements PersistenceExceptionTranslator {
    private static final PersistenceExceptionTranslator DEFAULT_EXCEPTION_TRANSLATOR = new MongoExceptionTranslator();
    private MongoOptions mongoOptions;
    private String host;
    private Integer port;
    private WriteConcern writeConcern;
    private List<ServerAddress> replicaSetSeeds;
    private List<ServerAddress> replicaPair;
    private PersistenceExceptionTranslator exceptionTranslator = DEFAULT_EXCEPTION_TRANSLATOR;

    public void setMongoOptions(MongoOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setReplicaSetSeeds(ServerAddress[] replicaSetSeeds) {
        this.replicaSetSeeds = MongoFactoryBean.filterNonNullElementsAsList(replicaSetSeeds);
    }

    @Deprecated
    public void setReplicaPair(ServerAddress[] replicaPair) {
        this.replicaPair = MongoFactoryBean.filterNonNullElementsAsList(replicaPair);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    public Class<? extends Mongo> getObjectType() {
        return Mongo.class;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    protected Mongo createInstance() throws Exception {
        Mongo mongo;
        ServerAddress defaultOptions = new ServerAddress();
        if (this.mongoOptions == null) {
            this.mongoOptions = new MongoOptions();
        }
        if (!MongoFactoryBean.isNullOrEmpty(this.replicaPair)) {
            if (this.replicaPair.size() < 2) {
                throw new CannotGetMongoDbConnectionException("A replica pair must have two server entries");
            }
            mongo = new Mongo(this.replicaPair.get(0), this.replicaPair.get(1), this.mongoOptions);
        } else if (!MongoFactoryBean.isNullOrEmpty(this.replicaSetSeeds)) {
            mongo = new Mongo(this.replicaSetSeeds, this.mongoOptions);
        } else {
            String mongoHost = StringUtils.hasText((String)this.host) ? this.host : defaultOptions.getHost();
            Mongo mongo2 = mongo = this.port != null ? new Mongo(new ServerAddress(mongoHost, this.port.intValue()), this.mongoOptions) : new Mongo(mongoHost, this.mongoOptions);
        }
        if (this.writeConcern != null) {
            mongo.setWriteConcern(this.writeConcern);
        }
        return mongo;
    }

    protected void destroyInstance(Mongo mongo) throws Exception {
        mongo.close();
    }

    private static boolean isNullOrEmpty(Collection<?> elements) {
        return elements == null || elements.isEmpty();
    }

    private static <T> List<T> filterNonNullElementsAsList(T[] elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<T> candidateElements = new ArrayList<T>();
        for (T element : elements) {
            if (element == null) continue;
            candidateElements.add(element);
        }
        return Collections.unmodifiableList(candidateElements);
    }
}

