/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.PathSortAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.lang.Contract;

public class PredicateQueryEngine
extends QueryEngine<KeyValueAdapter, Predicate<?>, Comparator<?>> {
    public static final PredicateQueryEngine INSTANCE = new PredicateQueryEngine();

    public PredicateQueryEngine() {
        this(new PathSortAccessor());
    }

    public PredicateQueryEngine(SortAccessor<Comparator<?>> sortAccessor) {
        super(new CriteriaAccessor<Predicate<?>>(){

            @Override
            public @Nullable Predicate<?> resolve(KeyValueQuery<?> query) {
                return (Predicate)query.getCriteria();
            }
        }, sortAccessor);
    }

    @Override
    public Collection<?> execute(@Nullable Predicate<?> criteria, @Nullable Comparator<?> sort, long offset, int rows, String keyspace) {
        return this.sortAndFilterMatchingRange(this.getRequiredAdapter().getAllOf(keyspace), criteria, sort, offset, rows);
    }

    @Override
    public long count(@Nullable Predicate<?> criteria, String keyspace) {
        return PredicateQueryEngine.filterMatchingRange(IterableConverter.toList(this.getRequiredAdapter().getAllOf(keyspace)), criteria, -1L, -1).size();
    }

    private List<?> sortAndFilterMatchingRange(Iterable<?> source, @Nullable Predicate<?> criteria, @Nullable Comparator sort, long offset, int rows) {
        List<?> tmp = IterableConverter.toList(source);
        if (sort != null) {
            tmp.sort(sort);
        }
        return PredicateQueryEngine.filterMatchingRange(tmp, criteria, offset, rows);
    }

    @Contract(value="!null, _, _, _ -> !null")
    private static <S> List<S> filterMatchingRange(List<S> source, @Nullable Predicate<?> criteria, long offset, int rows) {
        Stream stream = source.stream();
        if (criteria != null) {
            stream = stream.filter(criteria);
        }
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (rows > 0) {
            stream = stream.limit(rows);
        }
        return stream.collect(Collectors.toList());
    }
}

