/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.CollectionFactory;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.ForwardingCloseableIterator;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MapKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final Class<? extends Map> keySpaceMapType;
    private final Map<Serializable, Map<Serializable, Object>> store;

    public MapKeyValueAdapter() {
        this(ConcurrentHashMap.class);
    }

    public MapKeyValueAdapter(Class<? extends Map> mapType) {
        this(CollectionFactory.createMap(mapType, (int)100), mapType);
    }

    public MapKeyValueAdapter(Map<Serializable, Map<Serializable, Object>> store) {
        this(store, ClassUtils.getUserClass(store));
    }

    private MapKeyValueAdapter(Map<Serializable, Map<Serializable, Object>> store, Class<? extends Map> keySpaceMapType) {
        Assert.notNull(store, (String)"Store must not be null.");
        Assert.notNull(keySpaceMapType, (String)"Map type to be used for key spaces must not be null!");
        this.store = store;
        this.keySpaceMapType = keySpaceMapType;
    }

    @Override
    public Object put(Serializable id, Object item, Serializable keyspace) {
        Assert.notNull((Object)id, (String)"Cannot add item with null id.");
        Assert.notNull((Object)keyspace, (String)"Cannot add item for null collection.");
        return this.getKeySpaceMap(keyspace).put(id, item);
    }

    @Override
    public boolean contains(Serializable id, Serializable keyspace) {
        return this.get(id, keyspace) != null;
    }

    @Override
    public long count(Serializable keyspace) {
        return this.getKeySpaceMap(keyspace).size();
    }

    @Override
    public Object get(Serializable id, Serializable keyspace) {
        Assert.notNull((Object)id, (String)"Cannot get item with null id.");
        return this.getKeySpaceMap(keyspace).get(id);
    }

    @Override
    public Object delete(Serializable id, Serializable keyspace) {
        Assert.notNull((Object)id, (String)"Cannot delete item with null id.");
        return this.getKeySpaceMap(keyspace).remove(id);
    }

    public Collection<?> getAllOf(Serializable keyspace) {
        return this.getKeySpaceMap(keyspace).values();
    }

    @Override
    public CloseableIterator<Map.Entry<Serializable, Object>> entries(Serializable keyspace) {
        return new ForwardingCloseableIterator<Map.Entry<Serializable, Object>>(this.getKeySpaceMap(keyspace).entrySet().iterator());
    }

    @Override
    public void deleteAllOf(Serializable keyspace) {
        this.getKeySpaceMap(keyspace).clear();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    public void destroy() throws Exception {
        this.clear();
    }

    protected Map<Serializable, Object> getKeySpaceMap(Serializable keyspace) {
        Assert.notNull((Object)keyspace, (String)"Collection must not be null for lookup.");
        Map<Serializable, Object> map = this.store.get(keyspace);
        if (map != null) {
            return map;
        }
        this.addMapForKeySpace(keyspace);
        return this.store.get(keyspace);
    }

    private void addMapForKeySpace(Serializable keyspace) {
        this.store.put(keyspace, CollectionFactory.createMap(this.keySpaceMapType, (int)1000));
    }
}

