/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Iterator;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public class ForwardingCloseableIterator<T>
implements CloseableIterator<T> {
    private final Iterator<? extends T> delegate;
    private final Runnable closeHandler;

    public ForwardingCloseableIterator(Iterator<? extends T> delegate) {
        this(delegate, null);
    }

    public ForwardingCloseableIterator(Iterator<? extends T> delegate, Runnable closeHandler) {
        Assert.notNull(delegate, (String)"Delegate iterator must not be null!");
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public T next() {
        return this.delegate.next();
    }

    public void close() {
        if (this.closeHandler != null) {
            this.closeHandler.run();
        }
    }
}

