/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryRewriteInformation;
import org.springframework.data.jpa.repository.query.EntityQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParametrizedQuery;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.jpa.repository.query.TemplatedQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final EntityQuery query;
    private final Map<Class<?>, Boolean> knownProjections = new ConcurrentHashMap();
    private final Lazy<ParametrizedQuery> countQuery;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final QueryRewriter queryRewriter;
    private final QuerySortRewriter querySortRewriter;
    private final Lazy<ParameterBinder> countParameterBinder;
    private final ValueEvaluationContextProvider valueExpressionContextProvider;
    private final boolean hasDeclaredCountQuery;

    AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, JpaQueryConfiguration queryConfiguration) {
        this(method, em, method.getDeclaredQuery(queryString), countQueryString != null ? method.getDeclaredQuery(countQueryString) : null, queryConfiguration);
    }

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, DeclaredQuery query, @Nullable DeclaredQuery countQuery, JpaQueryConfiguration queryConfiguration) {
        super(method, em);
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)queryConfiguration, (String)"JpaQueryConfiguration must not be null");
        this.valueExpressionDelegate = queryConfiguration.getValueExpressionDelegate();
        this.valueExpressionContextProvider = this.valueExpressionDelegate.createValueContextProvider((Parameters)method.getParameters());
        this.query = TemplatedQuery.create(query, method.getEntityInformation(), queryConfiguration);
        this.hasDeclaredCountQuery = countQuery != null;
        this.countQuery = Lazy.of(() -> {
            if (countQuery != null) {
                return TemplatedQuery.create(countQuery, method.getEntityInformation(), queryConfiguration);
            }
            return this.query.deriveCountQuery(method.getCountQueryProjection());
        });
        this.countParameterBinder = Lazy.of(() -> this.createBinder((ParametrizedQuery)this.countQuery.get()));
        this.queryRewriter = queryConfiguration.getQueryRewriter(method);
        JpaParameters parameters = method.getParameters();
        this.querySortRewriter = parameters.hasDynamicProjection() ? SimpleQuerySortRewriter.INSTANCE : (parameters.hasPageableParameter() || parameters.hasSortParameter() ? new CachingQuerySortRewriter() : new UnsortedCachingQuerySortRewriter());
        if (!method.isNativeQuery() && this.query.usesJdbcStyleParameters()) {
            throw QueryCreationException.create((QueryMethod)method, (String)"JDBC-style parameters (?) are not supported for JPA queries");
        }
    }

    @Override
    public boolean hasDeclaredCountQuery() {
        return this.hasDeclaredCountQuery;
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        Sort sort = accessor.getSort();
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = this.getReturnedType(processor);
        QueryProvider sortedQuery = this.getSortedQuery(sort, returnedType);
        Query query = this.createJpaQuery(sortedQuery, sort, accessor.getPageable(), returnedType);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, accessor);
    }

    ReturnedType getReturnedType(ResultProcessor processor) {
        ReturnedType returnedType = processor.getReturnedType();
        Class returnedJavaType = returnedType.getReturnedType();
        if (!returnedType.isProjecting() || returnedJavaType.isInterface() || this.query.isNative()) {
            return returnedType;
        }
        Boolean known = this.knownProjections.get(returnedJavaType);
        if (known != null && known.booleanValue()) {
            return returnedType;
        }
        if (known != null && !known.booleanValue() || returnedJavaType.isArray() || this.getMetamodel().isJpaManaged(returnedJavaType) || !returnedType.needsCustomConstruction()) {
            if (known == null) {
                this.knownProjections.put(returnedJavaType, false);
            }
            return new NonProjectingReturnedType(returnedType);
        }
        this.knownProjections.put(returnedJavaType, true);
        return returnedType;
    }

    QueryProvider getSortedQuery(Sort sort, ReturnedType returnedType) {
        return this.querySortRewriter.getSorted(this.query, sort, returnedType);
    }

    @Override
    protected ParameterBinder createBinder() {
        return this.createBinder(this.query);
    }

    protected ParameterBinder createBinder(ParametrizedQuery query) {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), query, (ValueExpressionParser)this.valueExpressionDelegate, this.valueExpressionContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        String queryString = ((ParametrizedQuery)this.countQuery.get()).getQueryString();
        EntityManager em = this.getEntityManager();
        String queryStringToUse = this.potentiallyRewriteQuery(queryString, accessor.getSort(), accessor.getPageable());
        Query query = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryStringToUse) : em.createQuery(queryStringToUse, Long.class);
        ((ParameterBinder)this.countParameterBinder.get()).bind(new QueryParameterSetter.BindableQuery(query), accessor, QueryParameterSetter.ErrorHandling.LENIENT);
        return query;
    }

    public EntityQuery getQuery() {
        return this.query;
    }

    public ParametrizedQuery getCountQuery() {
        return (ParametrizedQuery)this.countQuery.get();
    }

    protected Query createJpaQuery(QueryProvider query, Sort sort, @Nullable Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        String queryToUse = this.potentiallyRewriteQuery(query.getQueryString(), sort, pageable);
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryToUse);
        }
        Class<?> typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(queryToUse) : em.createQuery(queryToUse, typeToRead);
    }

    protected String potentiallyRewriteQuery(String originalQuery, Sort sort, @Nullable Pageable pageable) {
        return pageable != null && pageable.isPaged() ? this.queryRewriter.rewrite(originalQuery, pageable) : this.queryRewriter.rewrite(originalQuery, sort);
    }

    QueryProvider applySorting(CachableQuery cachableQuery) {
        return cachableQuery.getDeclaredQuery().rewrite(new DefaultQueryRewriteInformation(cachableQuery.getSort(), cachableQuery.getReturnedType()));
    }

    static class CachableQuery {
        private final EntityQuery query;
        private final String queryString;
        private final Sort sort;
        private final ReturnedType returnedType;

        CachableQuery(EntityQuery query, Sort sort, ReturnedType returnedType) {
            this.query = query;
            this.queryString = query.getQueryString();
            this.sort = sort;
            this.returnedType = returnedType;
        }

        EntityQuery getDeclaredQuery() {
            return this.query;
        }

        Sort getSort() {
            return this.sort;
        }

        public ReturnedType getReturnedType() {
            return this.returnedType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachableQuery that = (CachableQuery)o;
            if (!Objects.equals(this.queryString, that.queryString)) {
                return false;
            }
            return Objects.equals(this.sort, that.sort);
        }

        public int hashCode() {
            int result = this.queryString != null ? this.queryString.hashCode() : 0;
            result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
            return result;
        }
    }

    class CachingQuerySortRewriter
    implements QuerySortRewriter {
        private final ConcurrentLruCache<CachableQuery, QueryProvider> queryCache = new ConcurrentLruCache(16, abstractStringBasedJpaQuery::applySorting);
        @Nullable
        private volatile QueryProvider cachedQuery;

        CachingQuerySortRewriter() {
        }

        @Override
        public QueryProvider getSorted(EntityQuery query, Sort sort, ReturnedType returnedType) {
            if (sort.isUnsorted()) {
                QueryProvider cachedQuery = this.cachedQuery;
                if (cachedQuery == null) {
                    this.cachedQuery = cachedQuery = (QueryProvider)this.queryCache.get((Object)new CachableQuery(query, sort, returnedType));
                }
                return cachedQuery;
            }
            return (QueryProvider)this.queryCache.get((Object)new CachableQuery(query, sort, returnedType));
        }
    }

    private static class NonProjectingReturnedType
    extends ReturnedType {
        private final ReturnedType delegate;

        NonProjectingReturnedType(ReturnedType delegate) {
            super(delegate.getDomainType());
            this.delegate = delegate;
        }

        public boolean isProjecting() {
            return false;
        }

        public Class<?> getReturnedType() {
            return this.delegate.getReturnedType();
        }

        public boolean needsCustomConstruction() {
            return false;
        }

        @Nullable
        public Class<?> getTypeToRead() {
            return this.delegate.getTypeToRead();
        }

        public List<String> getInputProperties() {
            return this.delegate.getInputProperties();
        }
    }

    static interface QuerySortRewriter {
        public QueryProvider getSorted(EntityQuery var1, Sort var2, ReturnedType var3);
    }

    static enum SimpleQuerySortRewriter implements QuerySortRewriter
    {
        INSTANCE;


        @Override
        public QueryProvider getSorted(EntityQuery query, Sort sort, ReturnedType returnedType) {
            return query.rewrite(new DefaultQueryRewriteInformation(sort, returnedType));
        }
    }

    static class UnsortedCachingQuerySortRewriter
    implements QuerySortRewriter {
        @Nullable
        private volatile QueryProvider cachedQuery;

        UnsortedCachingQuerySortRewriter() {
        }

        @Override
        public QueryProvider getSorted(EntityQuery query, Sort sort, ReturnedType returnedType) {
            if (sort.isSorted()) {
                throw new UnsupportedOperationException("NoOpQueryCache does not support sorting");
            }
            QueryProvider cachedQuery = this.cachedQuery;
            if (cachedQuery == null) {
                this.cachedQuery = cachedQuery = query.rewrite(new DefaultQueryRewriteInformation(sort, returnedType));
            }
            return cachedQuery;
        }
    }
}

