/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.aot.JpaRepositoryContributor;
import org.springframework.data.jpa.repository.config.InspectionClassLoader;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaEvaluationContextExtension;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.ImplementationDetectionConfiguration;
import org.springframework.data.repository.config.ImplementationLookupConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.util.Streamable;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME = "org.springframework.data.jpa.util.JpaMetamodelCacheCleanup";
    private static final String ESCAPE_CHARACTER_PROPERTY = "escapeCharacter";
    private final Map<Object, String> entityManagerRefs = new LinkedHashMap<Object, String>();

    public String getModuleName() {
        return "JPA";
    }

    public String getRepositoryFactoryBeanClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(JpaRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        if (this.entityManagerRefs.containsKey(source)) {
            builder.addPropertyReference("entityManager", this.entityManagerRefs.get(source));
        }
        builder.addPropertyValue(ESCAPE_CHARACTER_PROPERTY, (Object)JpaRepositoryConfigExtension.getEscapeCharacter(source).orElse(Character.valueOf('\\')));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
        if (source instanceof AnnotationRepositoryConfigurationSource) {
            builder.addPropertyValue("queryEnhancerSelector", source.getAttribute("queryEnhancerSelector", Class.class).orElse(null));
        }
    }

    public Class<? extends BeanRegistrationAotProcessor> getRepositoryAotProcessor() {
        return JpaRepositoryRegistrationAotProcessor.class;
    }

    private static Optional<Character> getEscapeCharacter(RepositoryConfigurationSource source) {
        try {
            return source.getAttribute(ESCAPE_CHARACTER_PROPERTY, Character.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.isPresent() && StringUtils.hasText((String)((String)enableDefaultTransactions.get()))) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions.get());
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        this.registerSharedEntityMangerIfNotAlreadyRegistered(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), (BeanDefinitionRegistry)registry, (String)"emBeanDefinitionRegistrarPostProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)"jpaMappingContext", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(PAB_POST_PROCESSOR), (BeanDefinitionRegistry)registry, (String)"org.springframework.context.annotation.internalPersistenceAnnotationProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> {
            RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
            contextDefinition.setAutowireMode(3);
            return contextDefinition;
        }, (BeanDefinitionRegistry)registry, (String)"jpaContext", (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME), (BeanDefinitionRegistry)registry, (String)JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME, (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            Object value = config instanceof AnnotationRepositoryConfigurationSource ? config.getRequiredAttribute(ESCAPE_CHARACTER_PROPERTY, Character.class) : config.getAttribute(ESCAPE_CHARACTER_PROPERTY).orElse("\\");
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JpaEvaluationContextExtension.class);
            builder.addConstructorArgValue(value);
            return builder.getBeanDefinition();
        }, (BeanDefinitionRegistry)registry, (String)JpaEvaluationContextExtension.class.getName(), (Object)source);
    }

    private String registerSharedEntityMangerIfNotAlreadyRegistered(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        String entityManagerBeanRef = JpaRepositoryConfigExtension.getEntityManagerBeanRef(config);
        String entityManagerBeanName = "jpaSharedEM_" + entityManagerBeanRef;
        if (!registry.containsBeanDefinition(entityManagerBeanName)) {
            AbstractBeanDefinition entityManager = JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(config, null);
            entityManager.setRole(1);
            entityManager.setPrimary(false);
            entityManager.setAutowireCandidate(false);
            registry.registerBeanDefinition(entityManagerBeanName, (BeanDefinition)entityManager);
        }
        this.entityManagerRefs.put(config, entityManagerBeanName);
        return entityManagerBeanName;
    }

    @Nullable
    protected ClassLoader getConfigurationInspectionClassLoader(ResourceLoader loader) {
        ClassLoader classLoader = loader.getClassLoader();
        return classLoader != null && LazyJvmAgent.isActive(loader.getClassLoader()) ? new InspectionClassLoader(classLoader) : classLoader;
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        Optional entityManagerFactoryRef = config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef.orElse("entityManagerFactory");
    }

    public static class JpaRepositoryRegistrationAotProcessor
    extends RepositoryRegistrationAotProcessor {
        @Nullable
        protected RepositoryContributor contribute(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
            boolean enabled = Boolean.parseBoolean(repositoryContext.getEnvironment().getProperty("spring.aot.repositories.enabled", "false"));
            if (!enabled) {
                return null;
            }
            ConfigurableListableBeanFactory beanFactory = repositoryContext.getBeanFactory();
            EntityManagerFactory emf = (EntityManagerFactory)beanFactory.getBeanProvider(EntityManagerFactory.class).getIfAvailable();
            return emf != null ? new JpaRepositoryContributor(repositoryContext, emf) : new JpaRepositoryContributor(repositoryContext);
        }

        @Nullable
        protected RepositoryConfiguration<?> getRepositoryMetadata(RegisteredBean bean) {
            RepositoryConfiguration configuration = super.getRepositoryMetadata(bean);
            if (configuration != null && configuration.getRepositoryBaseClassName().isPresent()) {
                return configuration;
            }
            return new Meh(configuration);
        }
    }

    static class LazyJvmAgent {
        private static final Set<String> AGENT_CLASSES;

        static {
            LinkedHashSet<String> agentClasses = new LinkedHashSet<String>();
            agentClasses.add("org.springframework.instrument.InstrumentationSavingAgent");
            agentClasses.add("org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializerAgent");
            AGENT_CLASSES = Collections.unmodifiableSet(agentClasses);
        }

        private LazyJvmAgent() {
        }

        static boolean isActive(@Nullable ClassLoader classLoader) {
            return AGENT_CLASSES.stream().anyMatch(agentClass -> ClassUtils.isPresent((String)agentClass, (ClassLoader)classLoader));
        }
    }

    static class Meh<T extends RepositoryConfigurationSource>
    implements RepositoryConfiguration<T> {
        private RepositoryConfiguration<?> configuration;

        public Meh(RepositoryConfiguration<?> configuration) {
            this.configuration = configuration;
        }

        @Nullable
        public Object getSource() {
            return this.configuration.getSource();
        }

        public T getConfigurationSource() {
            return (T)this.configuration.getConfigurationSource();
        }

        public boolean isLazyInit() {
            return this.configuration.isLazyInit();
        }

        public boolean isPrimary() {
            return this.configuration.isPrimary();
        }

        public Streamable<String> getBasePackages() {
            return this.configuration.getBasePackages();
        }

        public Streamable<String> getImplementationBasePackages() {
            return this.configuration.getImplementationBasePackages();
        }

        public String getRepositoryInterface() {
            return this.configuration.getRepositoryInterface();
        }

        public Optional<Object> getQueryLookupStrategyKey() {
            return Optional.ofNullable(this.configuration.getQueryLookupStrategyKey());
        }

        public Optional<String> getNamedQueriesLocation() {
            return this.configuration.getNamedQueriesLocation();
        }

        public Optional<String> getRepositoryBaseClassName() {
            String name = SimpleJpaRepository.class.getName();
            return Optional.of(name);
        }

        public String getRepositoryFactoryBeanClassName() {
            return this.configuration.getRepositoryFactoryBeanClassName();
        }

        public String getImplementationBeanName() {
            return this.configuration.getImplementationBeanName();
        }

        public String getRepositoryBeanName() {
            return this.configuration.getRepositoryBeanName();
        }

        public Streamable<TypeFilter> getExcludeFilters() {
            return this.configuration.getExcludeFilters();
        }

        public ImplementationDetectionConfiguration toImplementationDetectionConfiguration(MetadataReaderFactory factory) {
            return this.configuration.toImplementationDetectionConfiguration(factory);
        }

        public ImplementationLookupConfiguration toLookupConfiguration(MetadataReaderFactory factory) {
            return this.configuration.toLookupConfiguration(factory);
        }

        @Nullable
        public String getResourceDescription() {
            return this.configuration.getResourceDescription();
        }
    }
}

