/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.domain.PredicateSpecification;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

@FunctionalInterface
public interface UpdateSpecification<T>
extends Serializable {
    public static <T> UpdateSpecification<T> unrestricted() {
        return (root, query, builder) -> null;
    }

    public static <T> UpdateOperation<T> update(UpdateOperation<T> spec) {
        Assert.notNull(spec, (String)"UpdateSpecification must not be null");
        return spec;
    }

    public static <T> UpdateSpecification<T> where(UpdateSpecification<T> spec) {
        Assert.notNull(spec, (String)"UpdateSpecification must not be null");
        return spec;
    }

    public static <T> UpdateSpecification<T> where(PredicateSpecification<T> spec) {
        Assert.notNull(spec, (String)"PredicateSpecification must not be null");
        return UpdateSpecification.where((Root<T> root, CriteriaUpdate<T> update, CriteriaBuilder criteriaBuilder) -> spec.toPredicate(root, criteriaBuilder));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public UpdateSpecification<T> and(UpdateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public UpdateSpecification<T> and(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, UpdateSpecification.where(other), CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public UpdateSpecification<T> or(UpdateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public UpdateSpecification<T> or(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, UpdateSpecification.where(other), CriteriaBuilder::or);
    }

    public static <T> UpdateSpecification<T> not(UpdateSpecification<T> spec) {
        Assert.notNull(spec, (String)"Specification must not be null");
        return (root, update, builder) -> {
            Predicate predicate = spec.toPredicate(root, update, builder);
            return predicate != null ? builder.not((Expression)predicate) : null;
        };
    }

    @SafeVarargs
    public static <T> UpdateSpecification<T> allOf(UpdateSpecification<T> ... specifications) {
        return UpdateSpecification.allOf(Arrays.asList(specifications));
    }

    public static <T> UpdateSpecification<T> allOf(Iterable<UpdateSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(UpdateSpecification.unrestricted(), UpdateSpecification::and);
    }

    @SafeVarargs
    public static <T> UpdateSpecification<T> anyOf(UpdateSpecification<T> ... specifications) {
        return UpdateSpecification.anyOf(Arrays.asList(specifications));
    }

    public static <T> UpdateSpecification<T> anyOf(Iterable<UpdateSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(UpdateSpecification.unrestricted(), UpdateSpecification::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaUpdate<T> var2, CriteriaBuilder var3);

    @FunctionalInterface
    public static interface UpdateOperation<T> {
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public UpdateOperation<T> and(UpdateOperation<T> other) {
            Assert.notNull(other, (String)"Other UpdateOperation must not be null");
            return (root, update, criteriaBuilder) -> {
                this.apply(root, update, criteriaBuilder);
                other.apply(root, update, criteriaBuilder);
            };
        }

        @Contract(value="_ -> new")
        @CheckReturnValue
        default public UpdateSpecification<T> where(PredicateSpecification<T> specification) {
            Assert.notNull(specification, (String)"PredicateSpecification must not be null");
            return (root, update, criteriaBuilder) -> {
                this.apply(root, update, criteriaBuilder);
                return specification.toPredicate(root, criteriaBuilder);
            };
        }

        @Contract(value="_ -> new")
        @CheckReturnValue
        default public UpdateSpecification<T> where(UpdateSpecification<T> specification) {
            Assert.notNull(specification, (String)"UpdateSpecification must not be null");
            return (root, update, criteriaBuilder) -> {
                this.apply(root, update, criteriaBuilder);
                return specification.toPredicate(root, update, criteriaBuilder);
            };
        }

        public void apply(Root<T> var1, CriteriaUpdate<T> var2, CriteriaBuilder var3);
    }
}

