/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EmptyDeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryParameterSetterFactory;
import org.springframework.util.Assert;

class ParameterBinderFactory {
    ParameterBinderFactory() {
    }

    static ParameterBinder createBinder(JpaParameters parameters) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null");
        QueryParameterSetterFactory setterFactory = QueryParameterSetterFactory.basic(parameters);
        List<ParameterBinding> bindings = ParameterBinderFactory.getBindings(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, setterFactory));
    }

    static ParameterBinder createCriteriaBinder(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null");
        Assert.notNull(metadata, (String)"Parameter metadata must not be null");
        QueryParameterSetterFactory setterFactory = QueryParameterSetterFactory.forCriteriaQuery(parameters, metadata);
        List<ParameterBinding> bindings = ParameterBinderFactory.getBindings(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, setterFactory));
    }

    static ParameterBinder createQueryAwareBinder(JpaParameters parameters, DeclaredQuery query, ValueExpressionParser parser, ValueEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null");
        Assert.notNull((Object)query, (String)"StringQuery must not be null");
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null");
        List<ParameterBinding> bindings = query.getParameterBindings();
        QueryParameterSetterFactory expressionSetterFactory = QueryParameterSetterFactory.parsing(parser, evaluationContextProvider);
        QueryParameterSetterFactory basicSetterFactory = QueryParameterSetterFactory.basic(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, query, expressionSetterFactory, basicSetterFactory), !query.usesPaging());
    }

    private static List<ParameterBinding> getBindings(JpaParameters parameters) {
        ArrayList<ParameterBinding> result = new ArrayList<ParameterBinding>();
        int bindableParameterIndex = 0;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!parameter.isBindable()) continue;
            int index = ++bindableParameterIndex;
            ParameterBinding.BindingIdentifier bindingIdentifier = parameter.getName().map(it -> ParameterBinding.BindingIdentifier.of(it, index)).orElseGet(() -> ParameterBinding.BindingIdentifier.of(index));
            result.add(new ParameterBinding(bindingIdentifier, ParameterBinding.ParameterOrigin.ofParameter(bindingIdentifier)));
        }
        return result;
    }

    private static Iterable<QueryParameterSetter> createSetters(List<ParameterBinding> parameterBindings, QueryParameterSetterFactory ... factories) {
        return ParameterBinderFactory.createSetters(parameterBindings, EmptyDeclaredQuery.EMPTY_QUERY, factories);
    }

    private static Iterable<QueryParameterSetter> createSetters(List<ParameterBinding> parameterBindings, DeclaredQuery declaredQuery, QueryParameterSetterFactory ... strategies) {
        ArrayList<QueryParameterSetter> setters = new ArrayList<QueryParameterSetter>(parameterBindings.size());
        for (ParameterBinding parameterBinding : parameterBindings) {
            setters.add(ParameterBinderFactory.createQueryParameterSetter(parameterBinding, strategies, declaredQuery));
        }
        return setters;
    }

    private static QueryParameterSetter createQueryParameterSetter(ParameterBinding binding, QueryParameterSetterFactory[] strategies, DeclaredQuery declaredQuery) {
        QueryParameterSetterFactory[] queryParameterSetterFactoryArray = strategies;
        int n = strategies.length;
        int n2 = 0;
        while (n2 < n) {
            QueryParameterSetterFactory strategy = queryParameterSetterFactoryArray[n2];
            QueryParameterSetter setter = strategy.create(binding, declaredQuery);
            if (setter != null) {
                return setter;
            }
            ++n2;
        }
        return QueryParameterSetter.NOOP;
    }
}

