/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.springframework.data.jpa.repository.query.QueryToken;

class QueryTokens {
    static final QueryToken TOKEN_NONE = QueryTokens.token("");
    static final QueryToken TOKEN_COMMA = QueryTokens.token(", ");
    static final QueryToken TOKEN_SPACE = QueryTokens.token(" ");
    static final QueryToken TOKEN_DOT = QueryTokens.token(".");
    static final QueryToken TOKEN_EQUALS = QueryTokens.token(" = ");
    static final QueryToken TOKEN_OPEN_PAREN = QueryTokens.token("(");
    static final QueryToken TOKEN_CLOSE_PAREN = QueryTokens.token(")");
    static final QueryToken TOKEN_ORDER_BY = QueryTokens.expression("order by");
    static final QueryToken TOKEN_LOWER_FUNC = QueryTokens.token("lower(");
    static final QueryToken TOKEN_SELECT_COUNT = QueryTokens.token("select count(");
    static final QueryToken TOKEN_COUNT_FUNC = QueryTokens.token("count(");
    static final QueryToken TOKEN_DOUBLE_PIPE = QueryTokens.token(" || ");
    static final QueryToken TOKEN_OPEN_SQUARE_BRACKET = QueryTokens.token("[");
    static final QueryToken TOKEN_CLOSE_SQUARE_BRACKET = QueryTokens.token("]");
    static final QueryToken TOKEN_COLON = QueryTokens.token(":");
    static final QueryToken TOKEN_QUESTION_MARK = QueryTokens.token("?");
    static final QueryToken TOKEN_OPEN_BRACE = QueryTokens.token("{");
    static final QueryToken TOKEN_CLOSE_BRACE = QueryTokens.token("}");
    static final QueryToken TOKEN_DOUBLE_UNDERSCORE = QueryTokens.token("__");
    static final QueryToken TOKEN_AS = QueryTokens.expression("AS");
    static final QueryToken TOKEN_DESC = QueryTokens.expression("desc");
    static final QueryToken TOKEN_ASC = QueryTokens.expression("asc");
    static final QueryToken TOKEN_WITH = QueryTokens.expression("WITH");
    static final QueryToken TOKEN_NOT = QueryTokens.expression("NOT");
    static final QueryToken TOKEN_MATERIALIZED = QueryTokens.expression("materialized");
    static final QueryToken TOKEN_NULLS = QueryTokens.expression("NULLS");
    static final QueryToken TOKEN_FIRST = QueryTokens.expression("FIRST");
    static final QueryToken TOKEN_LAST = QueryTokens.expression("LAST");

    QueryTokens() {
    }

    static QueryToken token(TerminalNode node) {
        return QueryTokens.token(node.getText());
    }

    static QueryToken token(Token token) {
        return QueryTokens.token(token.getText());
    }

    static QueryToken token(String token) {
        return new SimpleQueryToken(token);
    }

    static QueryToken ventilated(Token token) {
        return new SimpleQueryToken(" " + token.getText() + " ");
    }

    static QueryToken expression(TerminalNode node) {
        return QueryTokens.expression(node.getText());
    }

    static QueryToken expression(Token token) {
        return QueryTokens.expression(token.getText());
    }

    static QueryToken expression(String expression) {
        return new ExpressionToken(expression);
    }

    static class ExpressionToken
    extends SimpleQueryToken {
        ExpressionToken(String token) {
            super(token);
        }

        @Override
        public boolean isExpression() {
            return true;
        }
    }

    static class SimpleQueryToken
    implements QueryToken {
        private final String token;

        SimpleQueryToken(String token) {
            this.token = token;
        }

        @Override
        public String value() {
            return this.token;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object object) {
            void that;
            if (this == object) {
                return true;
            }
            if (!(object instanceof QueryToken)) {
                return false;
            }
            QueryToken queryToken = (QueryToken)object;
            return this.value().equalsIgnoreCase(that.value());
        }

        public int hashCode() {
            return this.value().hashCode();
        }

        public String toString() {
            return this.value();
        }
    }
}

