/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;

class QueryTransformers {
    QueryTransformers() {
    }

    static class CountSelectionTokenStream
    implements QueryTokenStream {
        private final List<QueryToken> tokens;
        private final boolean requiresPrimaryAlias;

        CountSelectionTokenStream(List<QueryToken> tokens, boolean requiresPrimaryAlias) {
            this.tokens = tokens;
            this.requiresPrimaryAlias = requiresPrimaryAlias;
        }

        static CountSelectionTokenStream create(QueryTokenStream selection) {
            ArrayList<QueryToken> target = new ArrayList<QueryToken>(selection.size());
            boolean skipNext = false;
            boolean containsNew = false;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                QueryToken token = (QueryToken)iterator.next();
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                if (token.equals(QueryTokens.TOKEN_AS)) {
                    skipNext = true;
                    continue;
                }
                if (!token.equals(QueryTokens.TOKEN_COMMA) && token.isExpression()) {
                    token = QueryTokens.token(token.value());
                }
                if (!containsNew && token.value().contains("new")) {
                    containsNew = true;
                }
                target.add(token);
            }
            return new CountSelectionTokenStream(target, containsNew);
        }

        public Iterator<QueryToken> iterator() {
            return this.tokens.iterator();
        }

        public List<QueryToken> toList() {
            return this.tokens;
        }

        @Override
        public int size() {
            return this.tokens.size();
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.tokens.isEmpty();
        }

        public boolean requiresPrimaryAlias() {
            return this.requiresPrimaryAlias;
        }
    }
}

