/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarErrorListener;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarException;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;

abstract class JpaQueryParserSupport {
    private final ParseState state;

    JpaQueryParserSupport(String query) {
        this.state = new ParseState(query);
    }

    String renderSortedQuery(Sort sort) {
        try {
            return JpaQueryParsingToken.render(this.applySort(this.state.getContext(), sort));
        }
        catch (BadJpqlGrammarException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    String createCountQuery(@Nullable String countProjection) {
        try {
            return JpaQueryParsingToken.render(this.doCreateCountQuery(this.state.getContext(), countProjection));
        }
        catch (BadJpqlGrammarException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    String projection() {
        try {
            List<JpaQueryParsingToken> tokens = this.doFindProjection(this.state.getContext());
            return tokens.isEmpty() ? "" : JpaQueryParsingToken.render(tokens);
        }
        catch (BadJpqlGrammarException badJpqlGrammarException) {
            return "";
        }
    }

    @Nullable
    String findAlias() {
        try {
            return this.doFindAlias(this.state.getContext());
        }
        catch (BadJpqlGrammarException badJpqlGrammarException) {
            return null;
        }
    }

    boolean hasConstructorExpression() {
        try {
            return this.doCheckForConstructor(this.state.getContext());
        }
        catch (BadJpqlGrammarException badJpqlGrammarException) {
            return false;
        }
    }

    protected abstract ParserRuleContext parse(String var1);

    static void configureParser(String query, Lexer lexer, Parser parser) {
        BadJpqlGrammarErrorListener errorListener = new BadJpqlGrammarErrorListener(query);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
    }

    protected abstract List<JpaQueryParsingToken> applySort(ParserRuleContext var1, Sort var2);

    protected abstract List<JpaQueryParsingToken> doCreateCountQuery(ParserRuleContext var1, @Nullable String var2);

    @Nullable
    protected abstract String doFindAlias(ParserRuleContext var1);

    protected abstract List<JpaQueryParsingToken> doFindProjection(ParserRuleContext var1);

    protected abstract boolean doCheckForConstructor(ParserRuleContext var1);

    class ParseState {
        private final Lazy<ParserRuleContext> parsedQuery;
        @Nullable
        private volatile BadJpqlGrammarException error;
        private final String query;

        public ParseState(String query) {
            this.query = query;
            this.parsedQuery = Lazy.of(() -> JpaQueryParserSupport.this.parse(query));
        }

        public ParserRuleContext getContext() {
            BadJpqlGrammarException error = this.error;
            if (error != null) {
                throw error;
            }
            try {
                return (ParserRuleContext)this.parsedQuery.get();
            }
            catch (BadJpqlGrammarException e) {
                this.error = error = e;
                throw error;
            }
        }

        public String getQuery() {
            return this.query;
        }
    }
}

