/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.HashMap;
import java.util.Set;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import org.springframework.data.mapping.PropertyPath;

abstract class EntityGraphFactory {
    public static final String HINT = "javax.persistence.fetchgraph";

    EntityGraphFactory() {
    }

    public static <T> EntityGraph<T> create(EntityManager entityManager, Class<T> domainType, Set<String> properties) {
        EntityGraph entityGraph = entityManager.createEntityGraph(domainType);
        HashMap<String, Subgraph> existingSubgraphs = new HashMap<String, Subgraph>();
        for (String property : properties) {
            Subgraph current = null;
            String currentFullPath = "";
            for (PropertyPath path : PropertyPath.from((String)property, domainType)) {
                currentFullPath = currentFullPath + path.getSegment() + ".";
                if (path.hasNext()) {
                    Subgraph finalCurrent = current;
                    current = current == null ? existingSubgraphs.computeIfAbsent(currentFullPath, k -> entityGraph.addSubgraph(path.getSegment())) : existingSubgraphs.computeIfAbsent(currentFullPath, k -> finalCurrent.addSubgraph(path.getSegment()));
                    continue;
                }
                if (current == null) {
                    entityGraph.addAttributeNodes(new String[]{path.getSegment()});
                    continue;
                }
                current.addAttributeNodes(new String[]{path.getSegment()});
            }
        }
        return entityGraph;
    }
}

