/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;

abstract class FluentQuerySupport<R> {
    protected final Class<R> resultType;
    protected final Sort sort;
    @Nullable
    protected final Set<String> properties;
    protected final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    FluentQuerySupport(Class<R> resultType, Sort sort, @Nullable Collection<String> properties, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context) {
        this.resultType = resultType;
        this.sort = sort;
        this.properties = properties != null ? new HashSet<String>(properties) : null;
        this.context = context;
    }

    final Collection<String> mergeProperties(Collection<String> additionalProperties) {
        HashSet<String> newProperties = new HashSet<String>();
        if (this.properties != null) {
            newProperties.addAll(this.properties);
        }
        newProperties.addAll(additionalProperties);
        return Collections.unmodifiableCollection(newProperties);
    }

    final <S> Function<Object, R> getConversionFunction(Class<S> inputType, Class<R> targetType) {
        if (targetType.isAssignableFrom(inputType)) {
            return Function.identity();
        }
        if (targetType.isInterface()) {
            return o -> this.projectionFactory.createProjection(targetType, o);
        }
        return o -> DefaultConversionService.getSharedInstance().convert(o, targetType);
    }
}

