/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import com.mysema.query.jpa.impl.AbstractJPAQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.path.PathBuilder;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public AbstractJPAQuery<JPAQuery> createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, (JPQLTemplates)OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public AbstractJPAQuery<JPAQuery> createQuery(EntityPath<?> ... paths) {
        return (AbstractJPAQuery)this.createQuery().from(paths);
    }

    public JPQLQuery applyPagination(Pageable pageable, JPQLQuery query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private JPQLQuery addOrderByFrom(QSort qsort, JPQLQuery query) {
        List orderSpecifiers = qsort.getOrderSpecifiers();
        return (JPQLQuery)query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[orderSpecifiers.size()]));
    }

    private JPQLQuery addOrderByFrom(Sort sort, JPQLQuery query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), this.toQueryDslNullHandling(order.getNullHandling()));
    }

    private OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, (String)"NullHandling must not be null!");
        switch (nullHandling) {
            case NULLS_FIRST: {
                return OrderSpecifier.NullHandling.NullsFirst;
            }
            case NULLS_LAST: {
                return OrderSpecifier.NullHandling.NullsLast;
            }
        }
        return OrderSpecifier.NullHandling.Default;
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull((Object)order, (String)"Order must not be null!");
        Object sortPropertyExpression = this.builder;
        for (PropertyPath path = PropertyPath.from((String)order.getProperty(), (Class)this.builder.getType()); path != null; path = path.next()) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()).lower() : Expressions.path((Class)path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
        }
        return sortPropertyExpression;
    }
}

