/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import java.util.Iterator;
import javax.persistence.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ParameterBinder {
    private final JpaParameters parameters;
    private final Object[] values;

    public ParameterBinder(JpaParameters parameters, Object[] values) {
        Assert.notNull((Object)((Object)parameters));
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
    }

    ParameterBinder(JpaParameters parameters) {
        this(parameters, new Object[0]);
    }

    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    public <T extends Query> T bind(T query) {
        int methodParameterPosition = 0;
        int queryParameterPosition = 1;
        Iterator i$ = this.parameters.iterator();
        while (i$.hasNext()) {
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)i$.next());
            if (this.canBindParameter(parameter)) {
                Object value = this.computeParameterValue(parameter, this.values[methodParameterPosition], this.values);
                this.bind(query, parameter, value, queryParameterPosition++);
            }
            ++methodParameterPosition;
        }
        return query;
    }

    protected boolean canBindParameter(JpaParameters.JpaParameter parameter) {
        return parameter.isBindable();
    }

    private Object computeParameterValue(JpaParameters.JpaParameter parameter, Object value, Object[] values) {
        return value;
    }

    protected void bind(Query query, JpaParameters.JpaParameter parameter, Object value, int position) {
        if (parameter.isTemporalParameter()) {
            if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
                query.setParameter(parameter.getName(), (Date)value, parameter.getTemporalType());
            } else {
                query.setParameter(position, (Date)value, parameter.getTemporalType());
            }
            return;
        }
        if (this.hasNamedParameter(query) && parameter.isNamedParameter()) {
            query.setParameter(parameter.getName(), value);
        } else {
            query.setParameter(position, value);
        }
    }

    public Query bindAndPrepare(Query query) {
        return this.bindAndPrepare(query, this.parameters);
    }

    boolean hasNamedParameter(Query query) {
        return QueryUtils.hasNamedParameter(query);
    }

    private Query bindAndPrepare(Query query, Parameters<?, ?> parameters) {
        Query result = this.bind(query);
        if (!parameters.hasPageableParameter() || this.getPageable() == null) {
            return result;
        }
        result.setFirstResult(this.getPageable().getOffset());
        result.setMaxResults(this.getPageable().getPageSize());
        return result;
    }

    Object[] getValues() {
        return this.values;
    }

    JpaParameters getParameters() {
        return this.parameters;
    }
}

