/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain.support;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.jpa.util.BeanDefinitionUtils;
import org.springframework.util.StringUtils;

public class AuditingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        try {
            BeanDefinitionUtils.getBeanDefinition(BEAN_CONFIGURER_ASPECT_BEAN_NAME, beanFactory);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            throw new IllegalStateException("Invalid auditing setup! Make sure you've used @EnableJpaAuditing or <jpa:auditing /> correctly!", o_O);
        }
        for (String beanName : BeanDefinitionUtils.getEntityManagerFactoryBeanNames((ListableBeanFactory)beanFactory)) {
            BeanDefinition definition = BeanDefinitionUtils.getBeanDefinition(beanName, beanFactory);
            definition.setDependsOn(StringUtils.addStringToArray((String[])definition.getDependsOn(), (String)BEAN_CONFIGURER_ASPECT_BEAN_NAME));
        }
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AuditorAware.class, (boolean)true, (boolean)false)) {
            BeanDefinition definition = BeanDefinitionUtils.getBeanDefinition(beanName, beanFactory);
            definition.setLazyInit(true);
        }
    }
}

