/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String ENTITY_NAME = "entityName";
    private final JpaEntityMetadata<?> metadata;
    private String parsedQuery;

    public ExpressionBasedStringQuery(String query, JpaEntityMetadata<?> metadata) {
        super(query);
        Assert.notNull(metadata, (String)"JpaEntityMetadata must not be null!");
        this.metadata = metadata;
    }

    @Override
    public String getQuery() {
        if (this.parsedQuery == null) {
            String rawQuery = super.getQuery();
            this.parsedQuery = this.renderQueryIfExpressionOrReturnQuery(rawQuery);
        }
        return this.parsedQuery;
    }

    private String renderQueryIfExpressionOrReturnQuery(String query) {
        if (!ExpressionBasedStringQuery.containsExpression(query)) {
            return query;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        evalContext.setVariable(ENTITY_NAME, (Object)this.metadata.getEntityName());
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expr = parser.parseExpression(query, ParserContext.TEMPLATE_EXPRESSION);
        Object result = expr.getValue((EvaluationContext)evalContext, String.class);
        return result == null ? query : String.valueOf(result);
    }

    private static boolean containsExpression(String query) {
        return query.contains("#{#entityName}");
    }
}

