/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.query.StringQueryParameterBinder;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class SpelExpressionStringQueryParameterBinder
extends StringQueryParameterBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpelExpressionStringQueryParameterBinder.class);
    private static final String PARAMETER_BIND_FAILED = "Setting the parameter with name '%s' and position '%s' lead to an exception.";
    private final StringQuery query;
    private final EvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;

    public SpelExpressionStringQueryParameterBinder(JpaParameters parameters, Object[] values, StringQuery query, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(parameters, values, query);
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = query;
        this.parser = parser;
    }

    @Override
    public <T extends Query> T bind(T jpaQuery) {
        return this.potentiallyBindExpressionParameters(super.bind(jpaQuery));
    }

    private <T extends Query> T potentiallyBindExpressionParameters(T jpaQuery) {
        if (this.isJpaParameterInformationReliable(jpaQuery) && jpaQuery.getParameters().isEmpty()) {
            return jpaQuery;
        }
        for (StringQuery.ParameterBinding binding : this.query.getParameterBindings()) {
            if (!binding.isExpression()) continue;
            Expression expr = this.parseExpressionString(binding.getExpression());
            Object value = this.evaluateExpression(expr);
            try {
                if (binding.getName() != null) {
                    jpaQuery.setParameter(binding.getName(), binding.prepare(value));
                    continue;
                }
                jpaQuery.setParameter(binding.getPosition().intValue(), binding.prepare(value));
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn(String.format(PARAMETER_BIND_FAILED, binding.getName(), binding.getPosition()), (Throwable)iae);
            }
        }
        return jpaQuery;
    }

    private <T extends Query> boolean isJpaParameterInformationReliable(T jpaQuery) {
        String className = jpaQuery.getClass().getName();
        return className.startsWith("org.apache.openjpa") || className.startsWith("org.hibernate");
    }

    private Expression parseExpressionString(String expressionString) {
        return this.parser.parseExpression(expressionString);
    }

    private Object evaluateExpression(Expression expr) {
        return expr.getValue(this.getEvaluationContext(), Object.class);
    }

    private EvaluationContext getEvaluationContext() {
        return this.evaluationContextProvider.getEvaluationContext((Parameters)this.getParameters(), this.getValues());
    }

    @Override
    protected boolean canBindParameter(JpaParameters.JpaParameter parameter) {
        List<StringQuery.ParameterBinding> parameterBindings = this.query.getParameterBindings();
        if (parameterBindings.isEmpty()) {
            return super.canBindParameter(parameter);
        }
        int expressionParameterCount = 0;
        for (StringQuery.ParameterBinding binding : parameterBindings) {
            if (!binding.isExpression()) continue;
            ++expressionParameterCount;
        }
        boolean allParametersAreUsedInExpressions = parameterBindings.size() - expressionParameterCount == 0;
        return !allParametersAreUsedInExpressions && super.canBindParameter(parameter);
    }
}

