/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertStrategyFactory;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.MapEntityRowMapper;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.core.convert.SqlParametersFactory;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDataAccessStrategy
implements DataAccessStrategy {
    private final SqlGeneratorSource sqlGeneratorSource;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final NamedParameterJdbcOperations operations;
    private final SqlParametersFactory sqlParametersFactory;
    private final InsertStrategyFactory insertStrategyFactory;
    private final QueryMappingConfiguration queryMappingConfiguration;

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlParametersFactory sqlParametersFactory, InsertStrategyFactory insertStrategyFactory, QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)sqlParametersFactory, (String)"SqlParametersFactory must not be null");
        Assert.notNull((Object)insertStrategyFactory, (String)"InsertStrategyFactory must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.context = context;
        this.converter = converter;
        this.operations = operations;
        this.sqlParametersFactory = sqlParametersFactory;
        this.insertStrategyFactory = insertStrategyFactory;
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    @Override
    public Dialect getDialect() {
        return this.sqlGeneratorSource.getDialect();
    }

    @Override
    public NamedParameterJdbcOperations getJdbcOperations() {
        return this.operations;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forInsert(instance, domainType, identifier, idValueSource);
        String insertSql = this.sql(domainType).getInsert(parameterSource.getIdentifiers());
        return this.insertStrategyFactory.insertStrategy(idValueSource, this.getIdColumn(domainType)).execute(insertSql, (SqlParameterSource)parameterSource);
    }

    @Override
    public <T> Object[] insert(List<InsertSubject<T>> insertSubjects, Class<T> domainType, IdValueSource idValueSource) {
        Assert.notEmpty(insertSubjects, (String)"Batch insert must contain at least one InsertSubject");
        SqlIdentifierParameterSource[] sqlParameterSources = (SqlIdentifierParameterSource[])insertSubjects.stream().map(insertSubject -> this.sqlParametersFactory.forInsert(insertSubject.getInstance(), domainType, insertSubject.getIdentifier(), idValueSource)).toArray(SqlIdentifierParameterSource[]::new);
        String insertSql = this.sql(domainType).getInsert(sqlParameterSources[0].getIdentifiers());
        return this.insertStrategyFactory.batchInsertStrategy(idValueSource, this.getIdColumn(domainType)).execute(insertSql, (SqlParameterSource[])sqlParameterSources);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forUpdate(instance, domainType);
        if (parameterSource.size() <= 1) {
            return true;
        }
        return this.operations.update(this.sql(domainType).getUpdate(), (SqlParameterSource)parameterSource) != 0;
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number previousVersion) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forUpdate(instance, domainType);
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getUpdateWithVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception on saving entity of type %s", persistentEntity.getName()));
        }
        return true;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String deleteByIdSql = this.sql(domainType).getDeleteById();
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType);
        this.operations.update(deleteByIdSql, (SqlParameterSource)parameter);
    }

    @Override
    public void delete(Iterable<Object> ids, Class<?> domainType) {
        String deleteByIdInSql = this.sql(domainType).getDeleteByIdIn();
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryByIds(ids, domainType);
        this.operations.update(deleteByIdInSql, (SqlParameterSource)parameter);
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryById(id, domainType);
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getDeleteByIdAndVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception deleting entity of type %s", persistentEntity.getName()));
        }
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(this.getBaseType(propertyPath));
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + String.valueOf(propertyPath)));
        String delete = this.sql(rootEntity.getType()).createDeleteByPath(propertyPath);
        SqlIdentifierParameterSource parameters = this.sqlParametersFactory.forQueryById(rootId, rootEntity.getType());
        this.operations.update(delete, (SqlParameterSource)parameters);
    }

    @Override
    public void delete(Iterable<Object> rootIds, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(this.getBaseType(propertyPath));
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + String.valueOf(propertyPath)));
        String delete = this.sql(rootEntity.getType()).createDeleteInByPath(propertyPath);
        SqlIdentifierParameterSource parameters = this.sqlParametersFactory.forQueryByIds(rootIds, rootEntity.getType());
        this.operations.update(delete, (SqlParameterSource)parameters);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.operations.getJdbcOperations().update(this.sql(domainType).createDeleteAllSql(null));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.operations.getJdbcOperations().update(this.sql(this.getBaseType(propertyPath)).createDeleteAllSql(propertyPath));
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        String acquireLockByIdSql = this.sql(domainType).getAcquireLockById(lockMode);
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType);
        this.operations.query(acquireLockByIdSql, (SqlParameterSource)parameter, ResultSet::next);
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        String acquireLockAllSql = this.sql(domainType).getAcquireLockAll(lockMode);
        this.operations.getJdbcOperations().query(acquireLockAllSql, ResultSet::next);
    }

    @Override
    public long count(Class<?> domainType) {
        Long result = (Long)this.operations.getJdbcOperations().queryForObject(this.sql(domainType).getCount(), Long.class);
        Assert.notNull((Object)result, (String)"The result of a count query must not be null");
        return result;
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String findOneSql = this.sql(domainType).getFindOne();
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType);
        try {
            return (T)this.operations.queryForObject(findOneSql, (SqlParameterSource)parameter, this.getRowMapper(domainType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> List<T> findAll(Class<T> domainType) {
        return this.operations.query(this.sql(domainType).getFindAll(), this.getRowMapper(domainType));
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType) {
        return this.operations.queryForStream(this.sql(domainType).getFindAll(), (SqlParameterSource)new MapSqlParameterSource(), this.getRowMapper(domainType));
    }

    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryByIds(ids, domainType);
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        return this.operations.query(findAllInListSql, (SqlParameterSource)parameterSource, this.getRowMapper(domainType));
    }

    @Override
    public <T> Stream<T> streamAllByIds(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return Stream.empty();
        }
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryByIds(ids, domainType);
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        return this.operations.queryForStream(findAllInListSql, (SqlParameterSource)parameterSource, this.getRowMapper(domainType));
    }

    public List<Object> findAllByPath(final Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> propertyPath) {
        Assert.notNull((Object)identifier, (String)"identifier must not be null");
        Assert.notNull(propertyPath, (String)"propertyPath must not be null");
        final AggregatePath path = this.context.getAggregatePath(propertyPath);
        Class actualType = path.getLeafEntity().getType();
        String findAllByProperty = this.sql(actualType).getFindAllByProperty(identifier, propertyPath);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryByIdentifier(identifier);
        return this.operations.query(findAllByProperty, (SqlParameterSource)parameterSource, (RowMapper)new RowMapper<Object>(this){
            final /* synthetic */ DefaultDataAccessStrategy this$0;
            {
                this.this$0 = this$0;
            }

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                if (path.isMap()) {
                    return this.this$0.getMapEntityRowMapper(path, identifier).mapRow(rs, rowNum);
                }
                Identifier identifierToUse = identifier;
                if (!path.hasIdProperty() && path.isQualified()) {
                    AggregatePath.TableInfo tableInfo = path.getTableInfo();
                    identifierToUse = identifierToUse.withPart(tableInfo.qualifierColumnInfo().name(), rowNum, Object.class);
                }
                return this.this$0.getEntityRowMapper(path, identifierToUse).mapRow(rs, rowNum);
            }
        });
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        SqlIdentifierParameterSource parameter;
        String existsSql = this.sql(domainType).getExists();
        Boolean result = (Boolean)this.operations.queryForObject(existsSql, (SqlParameterSource)(parameter = this.sqlParametersFactory.forQueryById(id, domainType)), Boolean.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"The result of an exists query must not be null");
        return result;
    }

    public <T> List<T> findAll(Class<T> domainType, Sort sort) {
        return this.operations.query(this.sql(domainType).getFindAll(sort), this.getRowMapper(domainType));
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType, Sort sort) {
        return this.operations.queryForStream(this.sql(domainType).getFindAll(sort), (SqlParameterSource)new MapSqlParameterSource(), this.getRowMapper(domainType));
    }

    public <T> List<T> findAll(Class<T> domainType, Pageable pageable) {
        return this.operations.query(this.sql(domainType).getFindAll(pageable), this.getRowMapper(domainType));
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).selectByQuery(query, parameterSource);
        try {
            return Optional.ofNullable(this.operations.queryForObject(sqlQuery, (SqlParameterSource)parameterSource, this.getRowMapper(domainType)));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public <T> List<T> findAll(Query query, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).selectByQuery(query, parameterSource);
        return this.operations.query(sqlQuery, (SqlParameterSource)parameterSource, this.getRowMapper(domainType));
    }

    @Override
    public <T> Stream<T> streamAll(Query query, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).selectByQuery(query, parameterSource);
        return this.operations.queryForStream(sqlQuery, (SqlParameterSource)parameterSource, this.getRowMapper(domainType));
    }

    public <T> List<T> findAll(Query query, Class<T> domainType, Pageable pageable) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).selectByQuery(query, parameterSource, pageable);
        return this.operations.query(sqlQuery, (SqlParameterSource)parameterSource, this.getRowMapper(domainType));
    }

    @Override
    public <T> boolean exists(Query query, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).existsByQuery(query, parameterSource);
        Boolean result = (Boolean)this.operations.queryForObject(sqlQuery, (SqlParameterSource)parameterSource, Boolean.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"The result of an exists query must not be null");
        return result;
    }

    @Override
    public <T> long count(Query query, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String sqlQuery = this.sql(domainType).countByQuery(query, parameterSource);
        Long result = (Long)this.operations.queryForObject(sqlQuery, (SqlParameterSource)parameterSource, Long.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"The result of a count query must not be null.");
        return result;
    }

    private <T> RowMapper<? extends T> getRowMapper(Class<T> domainType) {
        RowMapper<T> targetRowMapper = this.queryMappingConfiguration.getRowMapper(domainType);
        if (targetRowMapper != null) {
            return targetRowMapper;
        }
        return new EntityRowMapper<T>(this.getRequiredPersistentEntity(domainType), this.converter);
    }

    private EntityRowMapper<?> getEntityRowMapper(AggregatePath path, Identifier identifier) {
        return new EntityRowMapper(path, this.converter, identifier);
    }

    private RowMapper<?> getMapEntityRowMapper(AggregatePath path, Identifier identifier) {
        AggregatePath.ColumnInfo qualifierColumnInfo = path.getTableInfo().qualifierColumnInfo();
        Assert.notNull((Object)qualifierColumnInfo, () -> "Qualifier column must not be null for " + String.valueOf(path));
        SqlIdentifier keyColumn = qualifierColumnInfo.name();
        return new MapEntityRowMapper(path, this.converter, identifier, keyColumn);
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private SqlGenerator sql(Class<?> domainType) {
        return this.sqlGeneratorSource.getSqlGenerator(domainType);
    }

    @Nullable
    private <T> SqlIdentifier getIdColumn(Class<T> domainType) {
        return Optional.ofNullable((RelationalPersistentProperty)((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdProperty()).map(RelationalPersistentProperty::getColumnName).orElse(null);
    }

    private Class<?> getBaseType(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentProperty baseProperty = (RelationalPersistentProperty)propertyPath.getBaseProperty();
        Assert.notNull((Object)baseProperty, (String)"The base property must not be null");
        return baseProperty.getOwner().getType();
    }
}

