/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.CallbackCapableRowMapper;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class DefaultRowMapperFactory
implements RowMapperFactory {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final EntityCallbacks entityCallbacks;
    private final ApplicationEventPublisher publisher;

    public DefaultRowMapperFactory(RelationalMappingContext context, JdbcConverter converter, QueryMappingConfiguration queryMappingConfiguration, EntityCallbacks entityCallbacks, ApplicationEventPublisher publisher) {
        this.context = context;
        this.converter = converter;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.entityCallbacks = entityCallbacks;
        this.publisher = publisher;
    }

    @Override
    public RowMapper<Object> create(Class<?> returnedObjectType) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance(returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultMapper(returnedObjectType);
    }

    private RowMapper<?> determineDefaultMapper(Class<?> returnedObjectType) {
        RowMapper<?> configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(returnedObjectType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        EntityRowMapper defaultEntityRowMapper = new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(returnedObjectType), this.converter);
        return new CallbackCapableRowMapper(defaultEntityRowMapper, this.publisher, this.entityCallbacks);
    }
}

