/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.data.jdbc.core.mapping.BasicJdbcPersistentProperty;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcMappingContext
extends RelationalMappingContext {
    private static final String MISSING_PARAMETER_NAME = "A constructor parameter name must not be null to be used with Spring Data JDBC; Offending parameter: %s";

    public JdbcMappingContext() {
        this.setSimpleTypeHolder(JdbcSimpleTypes.HOLDER);
    }

    public JdbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
        this.setSimpleTypeHolder(JdbcSimpleTypes.HOLDER);
    }

    protected <T> RelationalPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        RelationalPersistentEntity entity = super.createPersistentEntity(typeInformation);
        InstanceCreatorMetadata creator = entity.getInstanceCreatorMetadata();
        if (creator == null) {
            return entity;
        }
        for (Parameter parameter : creator.getParameters()) {
            Assert.state((boolean)StringUtils.hasText((String)parameter.getName()), () -> String.format(MISSING_PARAMETER_NAME, parameter));
        }
        return entity;
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicJdbcPersistentProperty persistentProperty = new BasicJdbcPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this.getNamingStrategy());
        this.applyDefaults(persistentProperty);
        return persistentProperty;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return super.shouldCreatePersistentEntityFor(type) && !AggregateReference.class.isAssignableFrom(type.getType()) && !type.isCollectionLike();
    }
}

