/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.ResultSetAccessor;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

class JdbcPropertyValueProvider
implements PropertyValueProvider<RelationalPersistentProperty> {
    private final PersistentPropertyPathExtension basePath;
    private final ResultSetAccessor resultSet;

    JdbcPropertyValueProvider(PersistentPropertyPathExtension basePath, ResultSetAccessor resultSet) {
        this.resultSet = resultSet;
        this.basePath = basePath;
    }

    public <T> T getPropertyValue(RelationalPersistentProperty property) {
        return (T)this.resultSet.getObject(this.getColumnName(property));
    }

    public boolean hasProperty(RelationalPersistentProperty property) {
        return this.resultSet.hasValue(this.getColumnName(property));
    }

    private String getColumnName(RelationalPersistentProperty property) {
        return this.basePath.extendBy(property).getColumnAlias().getReference();
    }

    public JdbcPropertyValueProvider extendBy(RelationalPersistentProperty property) {
        return new JdbcPropertyValueProvider(this.basePath.extendBy(property), this.resultSet);
    }
}

