/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.jdbc.repository.query.SqlContext;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalQueryCreator;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JdbcQueryCreator
extends RelationalQueryCreator<ParametrizedQuery> {
    private final RelationalMappingContext context;
    private final PartTree tree;
    private final RelationalParameterAccessor accessor;
    private final QueryMapper queryMapper;
    private final RelationalEntityMetadata<?> entityMetadata;
    private final RenderContextFactory renderContextFactory;
    private final boolean isSliceQuery;
    private final ReturnedType returnedType;
    private final Optional<Lock> lockMode;

    JdbcQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, boolean isSliceQuery, ReturnedType returnedType, Optional<Lock> lockMode) {
        super(tree, accessor);
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(entityMetadata, (String)"Relational entity metadata must not be null");
        Assert.notNull((Object)returnedType, (String)"ReturnedType must not be null");
        this.context = context;
        this.tree = tree;
        this.accessor = accessor;
        this.entityMetadata = entityMetadata;
        this.queryMapper = new QueryMapper(dialect, converter);
        this.renderContextFactory = new RenderContextFactory(dialect);
        this.isSliceQuery = isSliceQuery;
        this.returnedType = returnedType;
        this.lockMode = lockMode;
    }

    static void validate(PartTree tree, Parameters<?, ?> parameters, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        RelationalQueryCreator.validate((PartTree)tree, parameters);
        for (PartTree.OrPart parts : tree) {
            for (Part part : parts) {
                PersistentPropertyPathExtension path;
                PersistentPropertyPath propertyPath = context.getPersistentPropertyPath(part.getProperty());
                PersistentPropertyPathExtension pathToValidate = path = new PersistentPropertyPathExtension(context, propertyPath);
                while (path.getLength() > 0) {
                    JdbcQueryCreator.validateProperty(pathToValidate);
                    path = path.getParentPath();
                }
            }
        }
    }

    private static void validateProperty(PersistentPropertyPathExtension path) {
        if (!path.getParentPath().isEmbedded() && path.getLength() > 1) {
            throw new IllegalArgumentException(String.format("Cannot query by nested property: %s", path.getRequiredPersistentPropertyPath().toDotPath()));
        }
        if (path.isMultiValued() || path.isMap()) {
            throw new IllegalArgumentException(String.format("Cannot query by multi-valued property: %s", ((RelationalPersistentProperty)path.getRequiredPersistentPropertyPath().getLeafProperty()).getName()));
        }
        if (!path.isEmbedded() && path.isEntity()) {
            throw new IllegalArgumentException(String.format("Cannot query by nested entity: %s", path.getRequiredPersistentPropertyPath().toDotPath()));
        }
    }

    protected ParametrizedQuery complete(@Nullable Criteria criteria, Sort sort) {
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        Table table = Table.create((SqlIdentifier)this.entityMetadata.getTableName());
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        SelectBuilder.SelectLimitOffset limitOffsetBuilder = this.createSelectClause(entity, table);
        SelectBuilder.SelectWhere whereBuilder = this.applyLimitAndOffset(limitOffsetBuilder);
        SelectBuilder.SelectOrdered selectOrderBuilder = this.applyCriteria(criteria, entity, table, parameterSource, whereBuilder);
        SelectBuilder.SelectOrdered completedBuildSelect = selectOrderBuilder = this.applyOrderBy(sort, entity, table, selectOrderBuilder);
        if (this.lockMode.isPresent()) {
            completedBuildSelect = selectOrderBuilder.lock(this.lockMode.get().value());
        }
        Select select = completedBuildSelect.build();
        String sql = SqlRenderer.create((RenderContext)this.renderContextFactory.createRenderContext()).render(select);
        return new ParametrizedQuery(sql, (SqlParameterSource)parameterSource);
    }

    SelectBuilder.SelectOrdered applyOrderBy(Sort sort, RelationalPersistentEntity<?> entity, Table table, SelectBuilder.SelectOrdered selectOrdered) {
        return sort.isSorted() ? selectOrdered.orderBy(this.queryMapper.getMappedSort(table, sort, entity)) : selectOrdered;
    }

    SelectBuilder.SelectOrdered applyCriteria(@Nullable Criteria criteria, RelationalPersistentEntity<?> entity, Table table, MapSqlParameterSource parameterSource, SelectBuilder.SelectWhere whereBuilder) {
        return criteria != null ? whereBuilder.where(this.queryMapper.getMappedObject(parameterSource, (CriteriaDefinition)criteria, table, entity)) : whereBuilder;
    }

    SelectBuilder.SelectWhere applyLimitAndOffset(SelectBuilder.SelectLimitOffset limitOffsetBuilder) {
        if (this.tree.isExistsProjection()) {
            limitOffsetBuilder = limitOffsetBuilder.limit(1L);
        } else if (this.tree.isLimiting()) {
            limitOffsetBuilder = limitOffsetBuilder.limit((long)this.tree.getMaxResults().intValue());
        }
        Pageable pageable = this.accessor.getPageable();
        if (pageable.isPaged()) {
            limitOffsetBuilder = limitOffsetBuilder.limit(this.isSliceQuery ? (long)(pageable.getPageSize() + 1) : (long)pageable.getPageSize()).offset(pageable.getOffset());
        }
        return (SelectBuilder.SelectWhere)limitOffsetBuilder;
    }

    SelectBuilder.SelectLimitOffset createSelectClause(RelationalPersistentEntity<?> entity, Table table) {
        Object builder;
        if (this.tree.isExistsProjection()) {
            Column idColumn = table.column(entity.getIdColumn());
            builder = Select.builder().select((Expression)idColumn).from((TableLike)table);
        } else {
            builder = this.tree.isCountProjection() ? Select.builder().select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from((TableLike)table) : this.selectBuilder(table);
        }
        return (SelectBuilder.SelectLimitOffset)builder;
    }

    private SelectBuilder.SelectJoin selectBuilder(Table table) {
        ArrayList<Column> columnExpressions = new ArrayList<Column>();
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        SqlContext sqlContext = new SqlContext(entity);
        ArrayList<Join> joinTables = new ArrayList<Join>();
        for (PersistentPropertyPath path : this.context.findPersistentPropertyPaths(entity.getType(), p -> true)) {
            Column column;
            PersistentPropertyPathExtension extPath = new PersistentPropertyPathExtension((MappingContext)this.context, path);
            if (this.returnedType.needsCustomConstruction() && !this.returnedType.getInputProperties().contains(((RelationalPersistentProperty)extPath.getRequiredPersistentPropertyPath().getBaseProperty()).getName())) continue;
            Join join = this.getJoin(sqlContext, extPath);
            if (join != null) {
                joinTables.add(join);
            }
            if ((column = this.getColumn(sqlContext, extPath)) == null) continue;
            columnExpressions.add(column);
        }
        SelectBuilder.SelectAndFrom selectBuilder = StatementBuilder.select(columnExpressions);
        SelectBuilder.SelectFromAndJoin baseSelect = selectBuilder.from((TableLike)table);
        for (Join join : joinTables) {
            baseSelect = baseSelect.leftOuterJoin((TableLike)join.joinTable).on((Expression)join.joinColumn).equals((Expression)join.parentId);
        }
        return baseSelect;
    }

    @Nullable
    private Column getColumn(SqlContext sqlContext, PersistentPropertyPathExtension path) {
        if (path.isEmbedded() || path.getParentPath().isMultiValued()) {
            return null;
        }
        if (path.isEntity()) {
            if (path.isQualified() || path.isCollectionLike() || path.hasIdProperty()) {
                return null;
            }
            return sqlContext.getReverseColumn(path);
        }
        return sqlContext.getColumn(path);
    }

    @Nullable
    Join getJoin(SqlContext sqlContext, PersistentPropertyPathExtension path) {
        if (!path.isEntity() || path.isEmbedded() || path.isMultiValued()) {
            return null;
        }
        Table currentTable = sqlContext.getTable(path);
        PersistentPropertyPathExtension idDefiningParentPath = path.getIdDefiningParentPath();
        Table parentTable = sqlContext.getTable(idDefiningParentPath);
        return new Join(currentTable, currentTable.column(path.getReverseColumnName()), parentTable.column(idDefiningParentPath.getIdColumnName()));
    }

    private static final class Join {
        private final Table joinTable;
        private final Column joinColumn;
        private final Column parentId;

        Join(Table joinTable, Column joinColumn, Column parentId) {
            Assert.notNull((Object)joinTable, (String)"JoinTable must not be null");
            Assert.notNull((Object)joinColumn, (String)"JoinColumn must not be null");
            Assert.notNull((Object)parentId, (String)"ParentId must not be null");
            this.joinTable = joinTable;
            this.joinColumn = joinColumn;
            this.parentId = parentId;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Join join = (Join)o;
            return this.joinTable.equals((Object)join.joinTable) && this.joinColumn.equals((Object)join.joinColumn) && this.parentId.equals((Object)join.parentId);
        }

        public int hashCode() {
            return Objects.hash(this.joinTable, this.joinColumn, this.parentId);
        }

        public String toString() {
            return "Join{joinTable=" + this.joinTable + ", joinColumn=" + this.joinColumn + ", parentId=" + this.parentId + "}";
        }
    }
}

