/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.repository.support.FluentQuerySupport;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.repository.query.RelationalExampleMapper;

class FetchableFluentQueryByExample<S, R>
extends FluentQuerySupport<S, R> {
    private final RelationalExampleMapper exampleMapper;
    private final JdbcAggregateOperations entityOperations;

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, RelationalExampleMapper exampleMapper, JdbcAggregateOperations entityOperations) {
        this(example, Sort.unsorted(), resultType, Collections.emptyList(), exampleMapper, entityOperations);
    }

    FetchableFluentQueryByExample(Example<S> example, Sort sort, Class<R> resultType, List<String> fieldsToInclude, RelationalExampleMapper exampleMapper, JdbcAggregateOperations entityOperations) {
        super(example, sort, resultType, fieldsToInclude);
        this.exampleMapper = exampleMapper;
        this.entityOperations = entityOperations;
    }

    public R oneValue() {
        return (R)this.entityOperations.findOne(this.createQuery(), this.getExampleType()).map(item -> this.getConversionFunction().apply(item)).get();
    }

    public R firstValue() {
        return this.getConversionFunction().apply(this.entityOperations.findAll(this.createQuery().sort(this.getSort()), this.getExampleType()).iterator().next());
    }

    public List<R> all() {
        return StreamSupport.stream(this.entityOperations.findAll(this.createQuery().sort(this.getSort()), this.getExampleType()).spliterator(), false).map(item -> this.getConversionFunction().apply(item)).collect(Collectors.toList());
    }

    public Page<R> page(Pageable pageable) {
        return this.entityOperations.findAll(this.createQuery(p -> p.with(pageable)), this.getExampleType(), pageable).map(item -> this.getConversionFunction().apply(item));
    }

    public Stream<R> stream() {
        return StreamSupport.stream(this.entityOperations.findAll(this.createQuery().sort(this.getSort()), this.getExampleType()).spliterator(), false).map(item -> this.getConversionFunction().apply(item));
    }

    public long count() {
        return this.entityOperations.count(this.createQuery(), this.getExampleType());
    }

    public boolean exists() {
        return this.entityOperations.exists(this.createQuery(), this.getExampleType());
    }

    private Query createQuery() {
        return this.createQuery(UnaryOperator.identity());
    }

    private Query createQuery(UnaryOperator<Query> queryCustomizer) {
        Query query = this.exampleMapper.getMappedExample(this.getExample());
        if (!this.getFieldsToInclude().isEmpty()) {
            query = query.columns(this.getFieldsToInclude().toArray(new String[0]));
        }
        query = (Query)queryCustomizer.apply(query);
        return query;
    }

    @Override
    protected <R> FluentQuerySupport<S, R> create(Example<S> example, Sort sort, Class<R> resultType, List<String> fieldsToInclude) {
        return new FetchableFluentQueryByExample<S, R>(example, sort, resultType, fieldsToInclude, this.exampleMapper, this.entityOperations);
    }
}

