/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.mybatis;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.session.SqlSession;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.BatchJdbcOperations;
import org.springframework.data.jdbc.core.convert.CascadingDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DelegatingDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertStrategyFactory;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlParametersFactory;
import org.springframework.data.jdbc.mybatis.MyBatisContext;
import org.springframework.data.jdbc.mybatis.NamespaceStrategy;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class MyBatisDataAccessStrategy
implements DataAccessStrategy {
    private static final String VERSION_SQL_PARAMETER_NAME_OLD = "___oldOptimisticLockingVersion";
    private final SqlSession sqlSession;
    private NamespaceStrategy namespaceStrategy = NamespaceStrategy.DEFAULT_INSTANCE;

    public static DataAccessStrategy createCombinedAccessStrategy(RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlSession sqlSession, Dialect dialect) {
        return MyBatisDataAccessStrategy.createCombinedAccessStrategy(context, converter, operations, sqlSession, NamespaceStrategy.DEFAULT_INSTANCE, dialect);
    }

    public static DataAccessStrategy createCombinedAccessStrategy(RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlSession sqlSession, NamespaceStrategy namespaceStrategy, Dialect dialect) {
        SqlGeneratorSource sqlGeneratorSource = new SqlGeneratorSource(context, converter, dialect);
        SqlParametersFactory sqlParametersFactory = new SqlParametersFactory(context, converter, dialect);
        InsertStrategyFactory insertStrategyFactory = new InsertStrategyFactory(operations, new BatchJdbcOperations(operations.getJdbcOperations()), dialect);
        DefaultDataAccessStrategy defaultDataAccessStrategy = new DefaultDataAccessStrategy(sqlGeneratorSource, context, converter, operations, sqlParametersFactory, insertStrategyFactory);
        DelegatingDataAccessStrategy delegatingDataAccessStrategy = new DelegatingDataAccessStrategy(defaultDataAccessStrategy);
        MyBatisDataAccessStrategy myBatisDataAccessStrategy = new MyBatisDataAccessStrategy(sqlSession, dialect.getIdentifierProcessing());
        myBatisDataAccessStrategy.setNamespaceStrategy(namespaceStrategy);
        CascadingDataAccessStrategy cascadingDataAccessStrategy = new CascadingDataAccessStrategy(Arrays.asList(myBatisDataAccessStrategy, delegatingDataAccessStrategy));
        return cascadingDataAccessStrategy;
    }

    public MyBatisDataAccessStrategy(SqlSession sqlSession, IdentifierProcessing identifierProcessing) {
        this.sqlSession = sqlSession;
    }

    public void setNamespaceStrategy(NamespaceStrategy namespaceStrategy) {
        Assert.notNull((Object)namespaceStrategy, (String)"The NamespaceStrategy must not be null");
        this.namespaceStrategy = namespaceStrategy;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        MyBatisContext myBatisContext = new MyBatisContext(identifier, instance, domainType);
        this.sqlSession().insert(this.namespace(domainType) + ".insert", (Object)myBatisContext);
        return myBatisContext.getId();
    }

    @Override
    public <T> Object[] insert(List<InsertSubject<T>> insertSubjects, Class<T> domainType, IdValueSource idValueSource) {
        return insertSubjects.stream().map(insertSubject -> this.insert(insertSubject.getInstance(), domainType, insertSubject.getIdentifier(), idValueSource)).toArray();
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.sqlSession().update(this.namespace(domainType) + ".update", (Object)new MyBatisContext(null, instance, domainType, Collections.emptyMap())) != 0;
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number previousVersion) {
        String statement = this.namespace(domainType) + ".updateWithVersion";
        MyBatisContext parameter = new MyBatisContext(null, instance, domainType, Collections.singletonMap(VERSION_SQL_PARAMETER_NAME_OLD, previousVersion));
        return this.sqlSession().update(statement, (Object)parameter) != 0;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String statement = this.namespace(domainType) + ".delete";
        MyBatisContext parameter = new MyBatisContext(id, null, domainType, Collections.emptyMap());
        this.sqlSession().delete(statement, (Object)parameter);
    }

    @Override
    public void delete(Iterable<Object> ids, Class<?> domainType) {
        ids.forEach(id -> this.delete(id, domainType));
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        String statement = this.namespace(domainType) + ".deleteWithVersion";
        MyBatisContext parameter = new MyBatisContext(id, null, domainType, Collections.singletonMap(VERSION_SQL_PARAMETER_NAME_OLD, previousVersion));
        this.sqlSession().delete(statement, (Object)parameter);
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        Class<?> ownerType = this.getOwnerTyp(propertyPath);
        String statement = this.namespace(ownerType) + ".delete-" + MyBatisDataAccessStrategy.toDashPath(propertyPath);
        Class leafType = ((RelationalPersistentProperty)propertyPath.getRequiredLeafProperty()).getTypeInformation().getType();
        MyBatisContext parameter = new MyBatisContext(rootId, null, leafType, Collections.emptyMap());
        this.sqlSession().delete(statement, (Object)parameter);
    }

    @Override
    public void delete(Iterable<Object> rootIds, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        rootIds.forEach(rootId -> this.delete(rootId, propertyPath));
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        String statement = this.namespace(domainType) + ".deleteAll";
        MyBatisContext parameter = new MyBatisContext(null, null, domainType, Collections.emptyMap());
        this.sqlSession().delete(statement, (Object)parameter);
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        Class leafType = ((RelationalPersistentProperty)propertyPath.getRequiredLeafProperty()).getTypeInformation().getType();
        String statement = this.namespace(this.getOwnerTyp(propertyPath)) + ".deleteAll-" + MyBatisDataAccessStrategy.toDashPath(propertyPath);
        MyBatisContext parameter = new MyBatisContext(null, null, leafType, Collections.emptyMap());
        this.sqlSession().delete(statement, (Object)parameter);
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        String statement = this.namespace(domainType) + ".acquireLockById";
        MyBatisContext parameter = new MyBatisContext(id, null, domainType, Collections.emptyMap());
        long result = (Long)this.sqlSession().selectOne(statement, (Object)parameter);
        if (result < 1L) {
            String message = String.format("The lock target does not exist; id: %s, statement: %s", id, statement);
            throw new EmptyResultDataAccessException(message, 1);
        }
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        String statement = this.namespace(domainType) + ".acquireLockAll";
        MyBatisContext parameter = new MyBatisContext(null, null, domainType, Collections.emptyMap());
        this.sqlSession().selectOne(statement, (Object)parameter);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String statement = this.namespace(domainType) + ".findById";
        MyBatisContext parameter = new MyBatisContext(id, null, domainType, Collections.emptyMap());
        return (T)this.sqlSession().selectOne(statement, (Object)parameter);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        String statement = this.namespace(domainType) + ".findAll";
        MyBatisContext parameter = new MyBatisContext(null, null, domainType, Collections.emptyMap());
        return this.sqlSession().selectList(statement, (Object)parameter);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.sqlSession().selectList(this.namespace(domainType) + ".findAllById", (Object)new MyBatisContext(ids, null, domainType, Collections.emptyMap()));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        String statementName = this.namespace(this.getOwnerTyp(path)) + ".findAllByPath-" + path.toDotPath();
        return this.sqlSession().selectList(statementName, (Object)new MyBatisContext(identifier, null, ((RelationalPersistentProperty)path.getRequiredLeafProperty()).getType()));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        String statement = this.namespace(domainType) + ".existsById";
        MyBatisContext parameter = new MyBatisContext(id, null, domainType, Collections.emptyMap());
        return (Boolean)this.sqlSession().selectOne(statement, (Object)parameter);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        HashMap<String, Object> additionalContext = new HashMap<String, Object>();
        additionalContext.put("sort", sort);
        return this.sqlSession().selectList(this.namespace(domainType) + ".findAllSorted", (Object)new MyBatisContext(null, null, domainType, additionalContext));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Pageable pageable) {
        HashMap<String, Object> additionalContext = new HashMap<String, Object>();
        additionalContext.put("pageable", pageable);
        return this.sqlSession().selectList(this.namespace(domainType) + ".findAllPaged", (Object)new MyBatisContext(null, null, domainType, additionalContext));
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> probeType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> probeType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> probeType, Pageable pageable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> boolean exists(Query query, Class<T> probeType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> long count(Query query, Class<T> probeType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long count(Class<?> domainType) {
        String statement = this.namespace(domainType) + ".count";
        MyBatisContext parameter = new MyBatisContext(null, null, domainType, Collections.emptyMap());
        return (Long)this.sqlSession().selectOne(statement, (Object)parameter);
    }

    private String namespace(Class<?> domainType) {
        return this.namespaceStrategy.getNamespace(domainType);
    }

    private SqlSession sqlSession() {
        return this.sqlSession;
    }

    private static String toDashPath(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        String dotPath = propertyPath.toDotPath();
        if (dotPath == null) {
            return "";
        }
        return dotPath.replaceAll("\\.", "-");
    }

    private Class<?> getOwnerTyp(PersistentPropertyPath<? extends RelationalPersistentProperty> propertyPath) {
        RelationalPersistentProperty baseProperty = (RelationalPersistentProperty)propertyPath.getBaseProperty();
        Assert.notNull((Object)baseProperty, (String)"BaseProperty must not be null");
        return baseProperty.getOwner().getType();
    }
}

