/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.jdbc.repository.config.EnableJdbcAuditing;
import org.springframework.data.relational.auditing.RelationalAuditingCallback;
import org.springframework.data.repository.config.PersistentEntitiesFactoryBean;
import org.springframework.util.Assert;

class JdbcAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String AUDITING_HANDLER_BEAN_NAME = "jdbcAuditingHandler";
    private static final String JDBC_MAPPING_CONTEXT_BEAN_NAME = "jdbcMappingContext";

    JdbcAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableJdbcAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return AUDITING_HANDLER_BEAN_NAME;
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class));
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(PersistentEntitiesFactoryBean.class);
        definition.addConstructorArgReference(JDBC_MAPPING_CONTEXT_BEAN_NAME);
        return builder.addConstructorArgValue((Object)definition.getBeanDefinition());
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Class<RelationalAuditingCallback> listenerClass = RelationalAuditingCallback.class;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(listenerClass).addConstructorArgReference(AUDITING_HANDLER_BEAN_NAME);
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), listenerClass.getName(), registry);
    }
}

