/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertStrategyFactory;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.MapEntityRowMapper;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.core.convert.SqlParametersFactory;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDataAccessStrategy
implements DataAccessStrategy {
    private final SqlGeneratorSource sqlGeneratorSource;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final NamedParameterJdbcOperations operations;
    private final SqlParametersFactory sqlParametersFactory;
    private final InsertStrategyFactory insertStrategyFactory;

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlParametersFactory sqlParametersFactory, InsertStrategyFactory insertStrategyFactory) {
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)sqlParametersFactory, (String)"SqlParametersFactory must not be null");
        Assert.notNull((Object)insertStrategyFactory, (String)"InsertStrategyFactory must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.context = context;
        this.converter = converter;
        this.operations = operations;
        this.sqlParametersFactory = sqlParametersFactory;
        this.insertStrategyFactory = insertStrategyFactory;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
        return this.insert(instance, domainType, identifier, IdValueSource.forInstance(instance, (RelationalPersistentEntity)persistentEntity));
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forInsert(instance, domainType, identifier, idValueSource);
        String insertSql = this.sql(domainType).getInsert(parameterSource.getIdentifiers());
        return this.insertStrategyFactory.insertStrategy(idValueSource, this.getIdColumn(domainType)).execute(insertSql, (SqlParameterSource)parameterSource);
    }

    @Override
    public <T> Object[] insert(List<InsertSubject<T>> insertSubjects, Class<T> domainType, IdValueSource idValueSource) {
        Assert.notEmpty(insertSubjects, (String)"Batch insert must contain at least one InsertSubject");
        SqlIdentifierParameterSource[] sqlParameterSources = (SqlIdentifierParameterSource[])insertSubjects.stream().map(insertSubject -> this.sqlParametersFactory.forInsert(insertSubject.getInstance(), domainType, insertSubject.getIdentifier(), idValueSource)).toArray(SqlIdentifierParameterSource[]::new);
        String insertSql = this.sql(domainType).getInsert(sqlParameterSources[0].getIdentifiers());
        return this.insertStrategyFactory.batchInsertStrategy(idValueSource, this.getIdColumn(domainType)).execute(insertSql, (SqlParameterSource[])sqlParameterSources);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.operations.update(this.sql(domainType).getUpdate(), (SqlParameterSource)this.sqlParametersFactory.forUpdate(instance, domainType)) != 0;
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number previousVersion) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forUpdate(instance, domainType);
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getUpdateWithVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception on saving entity of type %s.", persistentEntity.getName()));
        }
        return true;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String deleteByIdSql = this.sql(domainType).getDeleteById();
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType, SqlGenerator.ID_SQL_PARAMETER);
        this.operations.update(deleteByIdSql, (SqlParameterSource)parameter);
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        Assert.notNull((Object)id, (String)"Id must not be null.");
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryById(id, domainType, SqlGenerator.ID_SQL_PARAMETER);
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getDeleteByIdAndVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception deleting entity of type %s.", persistentEntity.getName()));
        }
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType());
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + propertyPath));
        String delete = this.sql(rootEntity.getType()).createDeleteByPath(propertyPath);
        SqlIdentifierParameterSource parameters = this.sqlParametersFactory.forQueryById(rootId, rootEntity.getType(), SqlGenerator.ROOT_ID_PARAMETER);
        this.operations.update(delete, (SqlParameterSource)parameters);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.operations.getJdbcOperations().update(this.sql(domainType).createDeleteAllSql(null));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.operations.getJdbcOperations().update(this.sql(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType()).createDeleteAllSql(propertyPath));
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        String acquireLockByIdSql = this.sql(domainType).getAcquireLockById(lockMode);
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType, SqlGenerator.ID_SQL_PARAMETER);
        this.operations.query(acquireLockByIdSql, (SqlParameterSource)parameter, ResultSet::next);
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        String acquireLockAllSql = this.sql(domainType).getAcquireLockAll(lockMode);
        this.operations.getJdbcOperations().query(acquireLockAllSql, ResultSet::next);
    }

    @Override
    public long count(Class<?> domainType) {
        Long result = (Long)this.operations.getJdbcOperations().queryForObject(this.sql(domainType).getCount(), Long.class);
        Assert.notNull((Object)result, (String)"The result of a count query must not be null.");
        return result;
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String findOneSql = this.sql(domainType).getFindOne();
        SqlIdentifierParameterSource parameter = this.sqlParametersFactory.forQueryById(id, domainType, SqlGenerator.ID_SQL_PARAMETER);
        try {
            return (T)this.operations.queryForObject(findOneSql, (SqlParameterSource)parameter, this.getEntityRowMapper(domainType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.operations.query(this.sql(domainType).getFindAll(), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryByIds(ids, domainType);
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        return this.operations.query(findAllInListSql, (SqlParameterSource)parameterSource, this.getEntityRowMapper(domainType));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> propertyPath) {
        Assert.notNull((Object)identifier, (String)"identifier must not be null.");
        Assert.notNull(propertyPath, (String)"propertyPath must not be null.");
        PersistentPropertyPathExtension path = new PersistentPropertyPathExtension((MappingContext)this.context, propertyPath);
        Class actualType = path.getActualType();
        String findAllByProperty = this.sql(actualType).getFindAllByProperty(identifier, path.getQualifierColumn(), path.isOrdered());
        RowMapper<?> rowMapper = path.isMap() ? this.getMapEntityRowMapper(path, identifier) : this.getEntityRowMapper(path, identifier);
        SqlIdentifierParameterSource parameterSource = this.sqlParametersFactory.forQueryByIdentifier(identifier);
        return this.operations.query(findAllByProperty, (SqlParameterSource)parameterSource, rowMapper);
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        SqlIdentifierParameterSource parameter;
        String existsSql = this.sql(domainType).getExists();
        Boolean result = (Boolean)this.operations.queryForObject(existsSql, (SqlParameterSource)(parameter = this.sqlParametersFactory.forQueryById(id, domainType, SqlGenerator.ID_SQL_PARAMETER)), Boolean.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"The result of an exists query must not be null");
        return result;
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        return this.operations.query(this.sql(domainType).getFindAll(sort), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Pageable pageable) {
        return this.operations.query(this.sql(domainType).getFindAll(pageable), this.getEntityRowMapper(domainType));
    }

    private EntityRowMapper<?> getEntityRowMapper(Class<?> domainType) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(domainType), this.converter);
    }

    private EntityRowMapper<?> getEntityRowMapper(PersistentPropertyPathExtension path, Identifier identifier) {
        return new EntityRowMapper(path, this.converter, identifier);
    }

    private RowMapper<?> getMapEntityRowMapper(PersistentPropertyPathExtension path, Identifier identifier) {
        SqlIdentifier keyColumn = path.getQualifierColumn();
        Assert.notNull((Object)keyColumn, () -> "KeyColumn must not be null for " + path);
        return new MapEntityRowMapper(path, this.converter, identifier, keyColumn, this.getIdentifierProcessing());
    }

    private IdentifierProcessing getIdentifierProcessing() {
        return this.sqlGeneratorSource.getDialect().getIdentifierProcessing();
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private SqlGenerator sql(Class<?> domainType) {
        return this.sqlGeneratorSource.getSqlGenerator(domainType);
    }

    @Nullable
    private <T> SqlIdentifier getIdColumn(Class<T> domainType) {
        return Optional.ofNullable((RelationalPersistentProperty)((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdProperty()).map(RelationalPersistentProperty::getColumnName).orElse(null);
    }
}

