/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Map;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SqlGeneratorSource {
    private final Map<Class<?>, SqlGenerator> CACHE = new ConcurrentReferenceHashMap();
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;

    public Dialect getDialect() {
        return this.dialect;
    }

    SqlGenerator getSqlGenerator(Class<?> domainType) {
        return this.CACHE.computeIfAbsent(domainType, t -> new SqlGenerator(this.context, this.converter, (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(t), this.dialect));
    }

    public SqlGeneratorSource(RelationalMappingContext context, JdbcConverter converter, Dialect dialect) {
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
    }
}

