/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.InsertBuilder;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.UpdateBuilder;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SqlGenerator {
    static final SqlIdentifier VERSION_SQL_PARAMETER = SqlIdentifier.unquoted((String)"___oldOptimisticLockingVersion");
    static final SqlIdentifier ID_SQL_PARAMETER = SqlIdentifier.unquoted((String)"id");
    static final SqlIdentifier IDS_SQL_PARAMETER = SqlIdentifier.unquoted((String)"ids");
    static final SqlIdentifier ROOT_ID_PARAMETER = SqlIdentifier.unquoted((String)"rootId");
    private static final Pattern parameterPattern = Pattern.compile("\\W");
    private final RelationalPersistentEntity<?> entity;
    private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
    private final RenderContext renderContext;
    private final SqlContext sqlContext;
    private final SqlRenderer sqlRenderer;
    private final Columns columns;
    private final Lazy<String> findOneSql = Lazy.of(this::createFindOneSql);
    private final Lazy<String> findAllSql = Lazy.of(this::createFindAllSql);
    private final Lazy<String> findAllInListSql = Lazy.of(this::createFindAllInListSql);
    private final Lazy<String> existsSql = Lazy.of(this::createExistsSql);
    private final Lazy<String> countSql = Lazy.of(this::createCountSql);
    private final Lazy<String> updateSql = Lazy.of(this::createUpdateSql);
    private final Lazy<String> updateWithVersionSql = Lazy.of(this::createUpdateWithVersionSql);
    private final Lazy<String> deleteByIdSql = Lazy.of(this::createDeleteSql);
    private final Lazy<String> deleteByIdAndVersionSql = Lazy.of(this::createDeleteByIdAndVersionSql);
    private final Lazy<String> deleteByListSql = Lazy.of(this::createDeleteByListSql);

    SqlGenerator(RelationalMappingContext mappingContext, JdbcConverter converter, RelationalPersistentEntity<?> entity, Dialect dialect) {
        this.mappingContext = mappingContext;
        this.entity = entity;
        this.sqlContext = new SqlContext(entity);
        this.sqlRenderer = SqlRenderer.create((RenderContext)new RenderContextFactory(dialect).createRenderContext());
        this.columns = new Columns(entity, (MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty>)mappingContext, converter);
        this.renderContext = new RenderContextFactory(dialect).createRenderContext();
    }

    private Condition getSubselectCondition(PersistentPropertyPathExtension path, Function<Column, Condition> rootCondition, Column filterColumn) {
        PersistentPropertyPathExtension parentPath = path.getParentPath();
        if (!parentPath.hasIdProperty()) {
            if (parentPath.getLength() > 1) {
                return this.getSubselectCondition(parentPath, rootCondition, filterColumn);
            }
            return rootCondition.apply(filterColumn);
        }
        Table subSelectTable = Table.create((SqlIdentifier)parentPath.getTableName());
        Column idColumn = subSelectTable.column(parentPath.getIdColumnName());
        Column selectFilterColumn = subSelectTable.column(parentPath.getEffectiveIdColumnName());
        Condition innerCondition = parentPath.getLength() == 1 ? rootCondition.apply(selectFilterColumn) : this.getSubselectCondition(parentPath, rootCondition, selectFilterColumn);
        Select select = Select.builder().select((Expression)idColumn).from(subSelectTable).where(innerCondition).build();
        return filterColumn.in(select);
    }

    private BindMarker getBindMarker(SqlIdentifier columnName) {
        return SQL.bindMarker((String)(":" + parameterPattern.matcher(this.renderReference(columnName)).replaceAll("")));
    }

    String getFindAllInList() {
        return (String)this.findAllInListSql.get();
    }

    String getFindAll() {
        return (String)this.findAllSql.get();
    }

    String getFindAll(Sort sort) {
        return this.render(this.selectBuilder(Collections.emptyList(), sort, Pageable.unpaged()).build());
    }

    String getFindAll(Pageable pageable) {
        return this.render(this.selectBuilder(Collections.emptyList(), pageable.getSort(), pageable).build());
    }

    String getFindAllByProperty(Identifier parentIdentifier, @Nullable SqlIdentifier keyColumn, boolean ordered) {
        Assert.isTrue((keyColumn != null || !ordered ? 1 : 0) != 0, (String)"If the SQL statement should be ordered a keyColumn to order by must be provided.");
        Table table = this.getTable();
        SelectBuilder.SelectWhere builder = this.selectBuilder(keyColumn == null ? Collections.emptyList() : Collections.singleton(keyColumn));
        Condition condition = this.buildConditionForBackReference(parentIdentifier, table);
        SelectBuilder.SelectWhereAndOr withWhereClause = builder.where(condition);
        Select select = ordered ? withWhereClause.orderBy(new Column[]{table.column(keyColumn).as(keyColumn)}).build() : withWhereClause.build();
        return this.render(select);
    }

    private Condition buildConditionForBackReference(Identifier parentIdentifier, Table table) {
        Comparison condition = null;
        for (SqlIdentifier backReferenceColumn : parentIdentifier.toMap().keySet()) {
            Comparison newCondition = table.column(backReferenceColumn).isEqualTo((Expression)this.getBindMarker(backReferenceColumn));
            condition = condition == null ? newCondition : condition.and((Condition)newCondition);
        }
        Assert.state((condition != null ? 1 : 0) != 0, (String)"We need at least one condition");
        return condition;
    }

    String getExists() {
        return (String)this.existsSql.get();
    }

    String getFindOne() {
        return (String)this.findOneSql.get();
    }

    String getAcquireLockById(LockMode lockMode) {
        return this.createAcquireLockById(lockMode);
    }

    String getAcquireLockAll(LockMode lockMode) {
        return this.createAcquireLockAll(lockMode);
    }

    String getInsert(Set<SqlIdentifier> additionalColumns) {
        return this.createInsertSql(additionalColumns);
    }

    String getUpdate() {
        return (String)this.updateSql.get();
    }

    String getUpdateWithVersion() {
        return (String)this.updateWithVersionSql.get();
    }

    String getCount() {
        return (String)this.countSql.get();
    }

    String getDeleteById() {
        return (String)this.deleteByIdSql.get();
    }

    String getDeleteByIdAndVersion() {
        return (String)this.deleteByIdAndVersionSql.get();
    }

    String getDeleteByList() {
        return (String)this.deleteByListSql.get();
    }

    String createDeleteAllSql(@Nullable PersistentPropertyPath<RelationalPersistentProperty> path) {
        Table table = this.getTable();
        DeleteBuilder.DeleteWhere deleteAll = Delete.builder().from(table);
        if (path == null) {
            return this.render(deleteAll.build());
        }
        return this.createDeleteByPathAndCriteria(new PersistentPropertyPathExtension(this.mappingContext, path), Column::isNotNull);
    }

    String createDeleteByPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.createDeleteByPathAndCriteria(new PersistentPropertyPathExtension(this.mappingContext, path), filterColumn -> filterColumn.isEqualTo((Expression)this.getBindMarker(ROOT_ID_PARAMETER)));
    }

    private String createFindOneSql() {
        Select select = this.selectBuilder().where((Condition)this.getIdColumn().isEqualTo((Expression)this.getBindMarker(ID_SQL_PARAMETER))).build();
        return this.render(select);
    }

    private String createAcquireLockById(LockMode lockMode) {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)this.getIdColumn()).from(table).where((Condition)this.getIdColumn().isEqualTo((Expression)this.getBindMarker(ID_SQL_PARAMETER))).lock(lockMode).build();
        return this.render(select);
    }

    private String createAcquireLockAll(LockMode lockMode) {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)this.getIdColumn()).from(table).lock(lockMode).build();
        return this.render(select);
    }

    private String createFindAllSql() {
        return this.render(this.selectBuilder().build());
    }

    private SelectBuilder.SelectWhere selectBuilder() {
        return this.selectBuilder(Collections.emptyList());
    }

    private SelectBuilder.SelectWhere selectBuilder(Collection<SqlIdentifier> keyColumns) {
        Table table = this.getTable();
        ArrayList<Column> columnExpressions = new ArrayList<Column>();
        ArrayList<Join> joinTables = new ArrayList<Join>();
        for (PersistentPropertyPath path : this.mappingContext.findPersistentPropertyPaths(this.entity.getType(), p -> true)) {
            Column column;
            PersistentPropertyPathExtension extPath = new PersistentPropertyPathExtension(this.mappingContext, path);
            Join join = this.getJoin(extPath);
            if (join != null) {
                joinTables.add(join);
            }
            if ((column = this.getColumn(extPath)) == null) continue;
            columnExpressions.add(column);
        }
        for (SqlIdentifier keyColumn : keyColumns) {
            columnExpressions.add(table.column(keyColumn).as(keyColumn));
        }
        SelectBuilder.SelectAndFrom selectBuilder = StatementBuilder.select(columnExpressions);
        SelectBuilder.SelectFromAndJoin baseSelect = selectBuilder.from(table);
        for (Join join : joinTables) {
            baseSelect = baseSelect.leftOuterJoin(join.joinTable).on((Expression)join.joinColumn).equals((Expression)join.parentId);
        }
        return (SelectBuilder.SelectWhere)baseSelect;
    }

    private SelectBuilder.SelectOrdered selectBuilder(Collection<SqlIdentifier> keyColumns, Sort sort, Pageable pageable) {
        SelectBuilder.SelectWhere sortable = this.selectBuilder(keyColumns);
        sortable = this.applyPagination(pageable, (SelectBuilder.SelectOrdered)sortable);
        return sortable.orderBy(this.extractOrderByFields(sort));
    }

    private SelectBuilder.SelectOrdered applyPagination(Pageable pageable, SelectBuilder.SelectOrdered select) {
        if (!pageable.isPaged()) {
            return select;
        }
        Assert.isTrue((boolean)(select instanceof SelectBuilder.SelectLimitOffset), () -> String.format("Can't apply limit clause to statement of type %s", select.getClass()));
        SelectBuilder.SelectLimitOffset limitable = (SelectBuilder.SelectLimitOffset)select;
        SelectBuilder.SelectLimitOffset limitResult = limitable.limitOffset((long)pageable.getPageSize(), pageable.getOffset());
        Assert.state((boolean)(limitResult instanceof SelectBuilder.SelectOrdered), (String)String.format("The result of applying the limit-clause must be of type SelectOrdered in order to apply the order-by-clause but is of type %s.", select.getClass()));
        return (SelectBuilder.SelectOrdered)limitResult;
    }

    @Nullable
    Column getColumn(PersistentPropertyPathExtension path) {
        if (path.isEmbedded() || path.getParentPath().isMultiValued()) {
            return null;
        }
        if (path.isEntity()) {
            if (path.isQualified() || path.isCollectionLike() || path.hasIdProperty()) {
                return null;
            }
            return this.sqlContext.getReverseColumn(path);
        }
        return this.sqlContext.getColumn(path);
    }

    @Nullable
    Join getJoin(PersistentPropertyPathExtension path) {
        if (!path.isEntity() || path.isEmbedded() || path.isMultiValued()) {
            return null;
        }
        Table currentTable = this.sqlContext.getTable(path);
        PersistentPropertyPathExtension idDefiningParentPath = path.getIdDefiningParentPath();
        Table parentTable = this.sqlContext.getTable(idDefiningParentPath);
        return new Join(currentTable, currentTable.column(path.getReverseColumnName()), parentTable.column(idDefiningParentPath.getIdColumnName()));
    }

    private String createFindAllInListSql() {
        Select select = this.selectBuilder().where((Condition)this.getIdColumn().in(new Expression[]{this.getBindMarker(IDS_SQL_PARAMETER)})).build();
        return this.render(select);
    }

    private String createExistsSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{this.getIdColumn()})).from(table).where((Condition)this.getIdColumn().isEqualTo((Expression)this.getBindMarker(ID_SQL_PARAMETER))).build();
        return this.render(select);
    }

    private String createCountSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from(table).build();
        return this.render(select);
    }

    private String createInsertSql(Set<SqlIdentifier> additionalColumns) {
        Table table = this.getTable();
        TreeSet<SqlIdentifier> columnNamesForInsert = new TreeSet<SqlIdentifier>(Comparator.comparing(SqlIdentifier::getReference));
        columnNamesForInsert.addAll(this.columns.getInsertableColumns());
        columnNamesForInsert.addAll(additionalColumns);
        InsertBuilder.InsertIntoColumnsAndValuesWithBuild insert = Insert.builder().into(table);
        for (SqlIdentifier cn : columnNamesForInsert) {
            insert = insert.column(table.column(cn));
        }
        InsertBuilder.InsertValuesWithBuild insertWithValues = null;
        for (SqlIdentifier cn : columnNamesForInsert) {
            insertWithValues = ((InsertBuilder.InsertValues)(insertWithValues == null ? insert : insertWithValues)).values(new Expression[]{this.getBindMarker(cn)});
        }
        return this.render(insertWithValues == null ? insert.build() : insertWithValues.build());
    }

    private String createUpdateSql() {
        return this.render(this.createBaseUpdate().build());
    }

    private String createUpdateWithVersionSql() {
        Update update = this.createBaseUpdate().and((Condition)this.getVersionColumn().isEqualTo((Expression)SQL.bindMarker((String)(":" + this.renderReference(VERSION_SQL_PARAMETER))))).build();
        return this.render(update);
    }

    private UpdateBuilder.UpdateWhereAndOr createBaseUpdate() {
        Table table = this.getTable();
        List assignments = this.columns.getUpdateableColumns().stream().map(columnName -> Assignments.value((Column)table.column(columnName), (Expression)this.getBindMarker((SqlIdentifier)columnName))).collect(Collectors.toList());
        return Update.builder().table(table).set(assignments).where((Condition)this.getIdColumn().isEqualTo((Expression)this.getBindMarker(this.entity.getIdColumn())));
    }

    private String createDeleteSql() {
        return this.render(this.createBaseDeleteById(this.getTable()).build());
    }

    private String createDeleteByIdAndVersionSql() {
        Delete delete = this.createBaseDeleteById(this.getTable()).and((Condition)this.getVersionColumn().isEqualTo((Expression)SQL.bindMarker((String)(":" + this.renderReference(VERSION_SQL_PARAMETER))))).build();
        return this.render(delete);
    }

    private DeleteBuilder.DeleteWhereAndOr createBaseDeleteById(Table table) {
        return Delete.builder().from(table).where((Condition)this.getIdColumn().isEqualTo((Expression)SQL.bindMarker((String)(":" + this.renderReference(ID_SQL_PARAMETER)))));
    }

    private String createDeleteByPathAndCriteria(PersistentPropertyPathExtension path, Function<Column, Condition> rootCondition) {
        Delete delete;
        Table table = Table.create((SqlIdentifier)path.getTableName());
        DeleteBuilder.DeleteWhere builder = Delete.builder().from(table);
        Column filterColumn = table.column(path.getReverseColumnName());
        if (path.getLength() == 1) {
            delete = builder.where(rootCondition.apply(filterColumn)).build();
        } else {
            Condition condition = this.getSubselectCondition(path, rootCondition, filterColumn);
            delete = builder.where(condition).build();
        }
        return this.render(delete);
    }

    private String createDeleteByListSql() {
        Table table = this.getTable();
        Delete delete = Delete.builder().from(table).where((Condition)this.getIdColumn().in(new Expression[]{this.getBindMarker(IDS_SQL_PARAMETER)})).build();
        return this.render(delete);
    }

    private String render(Select select) {
        return this.sqlRenderer.render(select);
    }

    private String render(Insert insert) {
        return this.sqlRenderer.render(insert);
    }

    private String render(Update update) {
        return this.sqlRenderer.render(update);
    }

    private String render(Delete delete) {
        return this.sqlRenderer.render(delete);
    }

    private Table getTable() {
        return this.sqlContext.getTable();
    }

    private Column getIdColumn() {
        return this.sqlContext.getIdColumn();
    }

    private Column getVersionColumn() {
        return this.sqlContext.getVersionColumn();
    }

    private String renderReference(SqlIdentifier identifier) {
        return identifier.getReference(this.renderContext.getIdentifierProcessing());
    }

    private List<OrderByField> extractOrderByFields(Sort sort) {
        return sort.stream().map(this::orderToOrderByField).collect(Collectors.toList());
    }

    private OrderByField orderToOrderByField(Sort.Order order) {
        SqlIdentifier columnName = ((RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(order.getProperty())).getColumnName();
        Column column = Column.create((SqlIdentifier)columnName, (Table)this.getTable());
        return OrderByField.from((Column)column, (Sort.Direction)order.getDirection());
    }

    static class Columns {
        private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        private final JdbcConverter converter;
        private final List<SqlIdentifier> columnNames = new ArrayList<SqlIdentifier>();
        private final List<SqlIdentifier> idColumnNames = new ArrayList<SqlIdentifier>();
        private final List<SqlIdentifier> nonIdColumnNames = new ArrayList<SqlIdentifier>();
        private final Set<SqlIdentifier> readOnlyColumnNames = new HashSet<SqlIdentifier>();
        private final Set<SqlIdentifier> insertableColumns;
        private final Set<SqlIdentifier> updateableColumns;

        Columns(RelationalPersistentEntity<?> entity, MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext, JdbcConverter converter) {
            this.mappingContext = mappingContext;
            this.converter = converter;
            this.populateColumnNameCache(entity, "");
            LinkedHashSet<SqlIdentifier> insertable = new LinkedHashSet<SqlIdentifier>(this.nonIdColumnNames);
            insertable.removeAll(this.readOnlyColumnNames);
            this.insertableColumns = Collections.unmodifiableSet(insertable);
            LinkedHashSet<SqlIdentifier> updateable = new LinkedHashSet<SqlIdentifier>(this.columnNames);
            updateable.removeAll(this.idColumnNames);
            updateable.removeAll(this.readOnlyColumnNames);
            this.updateableColumns = Collections.unmodifiableSet(updateable);
        }

        private void populateColumnNameCache(RelationalPersistentEntity<?> entity, String prefix) {
            entity.doWithProperties(property -> {
                if (!property.isEntity()) {
                    this.initSimpleColumnName((RelationalPersistentProperty)property, prefix);
                } else if (property.isEmbedded()) {
                    this.initEmbeddedColumnNames((RelationalPersistentProperty)property, prefix);
                }
            });
        }

        private void initSimpleColumnName(RelationalPersistentProperty property, String prefix) {
            SqlIdentifier columnName = property.getColumnName().transform(prefix::concat);
            this.columnNames.add(columnName);
            if (!property.getOwner().isIdProperty((PersistentProperty)property)) {
                this.nonIdColumnNames.add(columnName);
            } else {
                this.idColumnNames.add(columnName);
            }
            if (!property.isWritable()) {
                this.readOnlyColumnNames.add(columnName);
            }
        }

        private void initEmbeddedColumnNames(RelationalPersistentProperty property, String prefix) {
            String embeddedPrefix = property.getEmbeddedPrefix();
            RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(this.converter.getColumnType(property));
            this.populateColumnNameCache(embeddedEntity, prefix + embeddedPrefix);
        }

        Set<SqlIdentifier> getInsertableColumns() {
            return this.insertableColumns;
        }

        Set<SqlIdentifier> getUpdateableColumns() {
            return this.updateableColumns;
        }
    }

    static final class Join {
        private final Table joinTable;
        private final Column joinColumn;
        private final Column parentId;

        public Join(Table joinTable, Column joinColumn, Column parentId) {
            this.joinTable = joinTable;
            this.joinColumn = joinColumn;
            this.parentId = parentId;
        }

        public Table getJoinTable() {
            return this.joinTable;
        }

        public Column getJoinColumn() {
            return this.joinColumn;
        }

        public Column getParentId() {
            return this.parentId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Join)) {
                return false;
            }
            Join other = (Join)o;
            Table this$joinTable = this.getJoinTable();
            Table other$joinTable = other.getJoinTable();
            if (this$joinTable == null ? other$joinTable != null : !this$joinTable.equals(other$joinTable)) {
                return false;
            }
            Column this$joinColumn = this.getJoinColumn();
            Column other$joinColumn = other.getJoinColumn();
            if (this$joinColumn == null ? other$joinColumn != null : !this$joinColumn.equals(other$joinColumn)) {
                return false;
            }
            Column this$parentId = this.getParentId();
            Column other$parentId = other.getParentId();
            return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Table $joinTable = this.getJoinTable();
            result = result * 59 + ($joinTable == null ? 43 : $joinTable.hashCode());
            Column $joinColumn = this.getJoinColumn();
            result = result * 59 + ($joinColumn == null ? 43 : $joinColumn.hashCode());
            Column $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            return result;
        }

        public String toString() {
            return "SqlGenerator.Join(joinTable=" + this.getJoinTable() + ", joinColumn=" + this.getJoinColumn() + ", parentId=" + this.getParentId() + ")";
        }
    }
}

