/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.AggregateChangeExecutor;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.conversion.RelationalEntityDeleteWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityInsertWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityUpdateWriter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.event.AfterDeleteCallback;
import org.springframework.data.relational.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.relational.core.mapping.event.AfterLoadCallback;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.relational.core.mapping.event.AfterSaveCallback;
import org.springframework.data.relational.core.mapping.event.AfterSaveEvent;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteCallback;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.relational.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.relational.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcAggregateTemplate
implements JdbcAggregateOperations {
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    private final RelationalEntityDeleteWriter jdbcEntityDeleteWriter;
    private final RelationalEntityInsertWriter jdbcEntityInsertWriter;
    private final RelationalEntityUpdateWriter jdbcEntityUpdateWriter;
    private final DataAccessStrategy accessStrategy;
    private final AggregateChangeExecutor executor;
    private EntityCallbacks entityCallbacks = EntityCallbacks.create();

    public JdbcAggregateTemplate(ApplicationContext publisher, RelationalMappingContext context, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationContext must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.accessStrategy = dataAccessStrategy;
        this.jdbcEntityInsertWriter = new RelationalEntityInsertWriter(context);
        this.jdbcEntityUpdateWriter = new RelationalEntityUpdateWriter(context);
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.executor = new AggregateChangeExecutor(converter, this.accessStrategy);
        this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)publisher));
    }

    public JdbcAggregateTemplate(ApplicationEventPublisher publisher, RelationalMappingContext context, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.accessStrategy = dataAccessStrategy;
        this.jdbcEntityInsertWriter = new RelationalEntityInsertWriter(context);
        this.jdbcEntityUpdateWriter = new RelationalEntityUpdateWriter(context);
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.executor = new AggregateChangeExecutor(converter, this.accessStrategy);
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"Callbacks must not be null.");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <T> T save(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        Function<Object, MutableAggregateChange> changeCreator = persistentEntity.isNew(instance) ? this::createInsertChange : this::createUpdateChange;
        return (T)this.store(instance, changeCreator, persistentEntity);
    }

    @Override
    public <T> T insert(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        return (T)this.store(instance, this::createInsertChange, persistentEntity);
    }

    @Override
    public <T> T update(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        return (T)this.store(instance, this::createUpdateChange, persistentEntity);
    }

    @Override
    public long count(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        return this.accessStrategy.count(domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        T entity = this.accessStrategy.findById(id, domainType);
        if (entity != null) {
            return this.triggerAfterLoad(entity);
        }
        return entity;
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        return this.accessStrategy.existsById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> all = this.accessStrategy.findAll(domainType, sort);
        return this.triggerAfterLoad((T)all);
    }

    @Override
    public <T> Page<T> findAll(Class<T> domainType, Pageable pageable) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> items = this.triggerAfterLoad((T)this.accessStrategy.findAll(domainType, pageable));
        long totalCount = this.accessStrategy.count(domainType);
        return new PageImpl(StreamSupport.stream(items.spliterator(), false).collect(Collectors.toList()), pageable, totalCount);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> all = this.accessStrategy.findAll(domainType);
        return this.triggerAfterLoad((T)all);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> allById = this.accessStrategy.findAllById(ids, domainType);
        return this.triggerAfterLoad((T)allById);
    }

    public <S> void delete(S aggregateRoot, Class<S> domainType) {
        Assert.notNull(aggregateRoot, (String)"Aggregate root must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        IdentifierAccessor identifierAccessor = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdentifierAccessor(aggregateRoot);
        this.deleteTree(identifierAccessor.getRequiredIdentifier(), aggregateRoot, domainType);
    }

    public <S> void deleteById(Object id, Class<S> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        this.deleteTree(id, null, domainType);
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        MutableAggregateChange<?> change = this.createDeletingChange(domainType);
        this.executor.execute(change);
    }

    private <T> T store(T aggregateRoot, Function<T, MutableAggregateChange<T>> changeCreator, RelationalPersistentEntity<?> persistentEntity) {
        Assert.notNull(aggregateRoot, (String)"Aggregate instance must not be null!");
        aggregateRoot = this.triggerBeforeConvert(aggregateRoot);
        MutableAggregateChange<T> change = changeCreator.apply(aggregateRoot);
        aggregateRoot = this.triggerBeforeSave(aggregateRoot, (AggregateChange<T>)change);
        change.setEntity(aggregateRoot);
        T entityAfterExecution = this.executor.execute(change);
        Object identifier = persistentEntity.getIdentifierAccessor(entityAfterExecution).getIdentifier();
        Assert.notNull((Object)identifier, (String)"After saving the identifier must not be null!");
        return this.triggerAfterSave(entityAfterExecution, (AggregateChange<T>)change);
    }

    private <T> void deleteTree(Object id, @Nullable T entity, Class<T> domainType) {
        MutableAggregateChange<T> change = this.createDeletingChange(id, entity, domainType);
        entity = this.triggerBeforeDelete(entity, id, change);
        change.setEntity(entity);
        this.executor.execute(change);
        this.triggerAfterDelete(entity, id, change);
    }

    private <T> MutableAggregateChange<T> createInsertChange(T instance) {
        MutableAggregateChange aggregateChange = MutableAggregateChange.forSave(instance);
        this.jdbcEntityInsertWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> MutableAggregateChange<T> createUpdateChange(T instance) {
        MutableAggregateChange aggregateChange = MutableAggregateChange.forSave(instance);
        this.jdbcEntityUpdateWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> MutableAggregateChange<T> createDeletingChange(Object id, @Nullable T entity, Class<T> domainType) {
        MutableAggregateChange aggregateChange = MutableAggregateChange.forDelete(domainType, entity);
        this.jdbcEntityDeleteWriter.write(id, aggregateChange);
        return aggregateChange;
    }

    private MutableAggregateChange<?> createDeletingChange(Class<?> domainType) {
        MutableAggregateChange aggregateChange = MutableAggregateChange.forDelete(domainType, null);
        this.jdbcEntityDeleteWriter.write(null, aggregateChange);
        return aggregateChange;
    }

    private <T> Iterable<T> triggerAfterLoad(Iterable<T> all) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : all) {
            result.add(this.triggerAfterLoad(e));
        }
        return result;
    }

    private <T> T triggerAfterLoad(T entity) {
        this.publisher.publishEvent((ApplicationEvent)new AfterLoadEvent(entity));
        return (T)this.entityCallbacks.callback(AfterLoadCallback.class, entity, new Object[0]);
    }

    private <T> T triggerBeforeConvert(T aggregateRoot) {
        return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> T triggerBeforeSave(T aggregateRoot, AggregateChange<T> change) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(aggregateRoot, change));
        return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, aggregateRoot, new Object[]{change});
    }

    private <T> T triggerAfterSave(T aggregateRoot, AggregateChange<T> change) {
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(aggregateRoot, change));
        return (T)this.entityCallbacks.callback(AfterSaveCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> void triggerAfterDelete(@Nullable T aggregateRoot, Object id, MutableAggregateChange<T> change) {
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(Identifier.of((Object)id), aggregateRoot, change));
        if (aggregateRoot != null) {
            this.entityCallbacks.callback(AfterDeleteCallback.class, aggregateRoot, new Object[0]);
        }
    }

    @Nullable
    private <T> T triggerBeforeDelete(@Nullable T aggregateRoot, Object id, MutableAggregateChange<T> change) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(Identifier.of((Object)id), aggregateRoot, change));
        if (aggregateRoot != null) {
            return (T)this.entityCallbacks.callback(BeforeDeleteCallback.class, aggregateRoot, new Object[]{change});
        }
        return null;
    }
}

