/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.lang.reflect.Array;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.ArrayUtil;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.IterableOfEntryToMapConverter;
import org.springframework.data.jdbc.core.convert.JdbcBackReferencePropertyValueProvider;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcPropertyValueProvider;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.jdbc.core.convert.ResultSetAccessor;
import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicJdbcConverter
extends BasicRelationalConverter
implements JdbcConverter {
    private static final Logger LOG = LoggerFactory.getLogger(BasicJdbcConverter.class);
    private static final Converter<Iterable<?>, Map<?, ?>> ITERABLE_OF_ENTRY_TO_MAP_CONVERTER = new IterableOfEntryToMapConverter();
    private final JdbcTypeFactory typeFactory;
    private final IdentifierProcessing identifierProcessing;
    private final RelationResolver relationResolver;

    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, RelationResolver relationResolver) {
        super(context);
        Assert.notNull((Object)relationResolver, (String)"RelationResolver must not be null");
        this.relationResolver = relationResolver;
        this.typeFactory = JdbcTypeFactory.unsupported();
        this.identifierProcessing = IdentifierProcessing.ANSI;
    }

    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, RelationResolver relationResolver, CustomConversions conversions, JdbcTypeFactory typeFactory, IdentifierProcessing identifierProcessing) {
        super(context, conversions);
        Assert.notNull((Object)typeFactory, (String)"JdbcTypeFactory must not be null");
        Assert.notNull((Object)relationResolver, (String)"RelationResolver must not be null");
        Assert.notNull((Object)identifierProcessing, (String)"IdentifierProcessing must not be null");
        this.relationResolver = relationResolver;
        this.typeFactory = typeFactory;
        this.identifierProcessing = identifierProcessing;
    }

    @Nullable
    private Class<?> getEntityColumnType(Class<?> type) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(type);
        if (persistentEntity == null) {
            return null;
        }
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        return this.getColumnType(idProperty);
    }

    private Class<?> getReferenceColumnType(RelationalPersistentProperty property) {
        Class componentType = property.getTypeInformation().getRequiredComponentType().getType();
        RelationalPersistentEntity referencedEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(componentType);
        return this.getColumnType((RelationalPersistentProperty)referencedEntity.getRequiredIdProperty());
    }

    @Override
    public int getSqlType(RelationalPersistentProperty property) {
        return JdbcUtil.sqlTypeFor(this.getColumnType(property));
    }

    @Override
    public Class<?> getColumnType(RelationalPersistentProperty property) {
        return this.doGetColumnType(property);
    }

    private Class<?> doGetColumnType(RelationalPersistentProperty property) {
        Class<?> columnType;
        if (property.isReference()) {
            return this.getReferenceColumnType(property);
        }
        if (property.isEntity() && (columnType = this.getEntityColumnType(property.getActualType())) != null) {
            return columnType;
        }
        Class<?> componentColumnType = JdbcColumnTypes.INSTANCE.resolvePrimitiveType(property.getActualType());
        while (componentColumnType.isArray()) {
            componentColumnType = componentColumnType.getComponentType();
        }
        if (property.isCollectionLike() && !property.isEntity()) {
            return Array.newInstance(componentColumnType, 0).getClass();
        }
        return componentColumnType;
    }

    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return value;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), type.getType())) {
            return this.getConversionService().convert(value, type.getType());
        }
        if (AggregateReference.class.isAssignableFrom(type.getType())) {
            if (type.getType().isAssignableFrom(value.getClass())) {
                return value;
            }
            return this.readAggregateReference(value, type);
        }
        if (value instanceof java.sql.Array) {
            try {
                return this.readValue(((java.sql.Array)value).getArray(), type);
            }
            catch (SQLException | ConverterNotFoundException e) {
                LOG.info("Failed to extract a value of type %s from an Array. Attempting to use standard conversions.", e);
            }
        }
        return super.readValue(value, type);
    }

    private Object readAggregateReference(@Nullable Object value, TypeInformation<?> type) {
        TypeInformation idType = (TypeInformation)type.getSuperTypeInformation(AggregateReference.class).getTypeArguments().get(1);
        return AggregateReference.to(this.readValue(value, idType));
    }

    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (AggregateReference.class.isAssignableFrom(value.getClass())) {
            return this.writeValue(((AggregateReference)value).getId(), type);
        }
        return super.writeValue(value, type);
    }

    private boolean canWriteAsJdbcValue(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        if (AggregateReference.class.isAssignableFrom(value.getClass())) {
            return this.canWriteAsJdbcValue(((AggregateReference)value).getId());
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(value.getClass());
        if (persistentEntity != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.canWriteAsJdbcValue(id);
        }
        if (value instanceof JdbcValue) {
            return true;
        }
        Optional customWriteTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        return customWriteTarget.isPresent() && ((Class)customWriteTarget.get()).isAssignableFrom(JdbcValue.class);
    }

    @Override
    public JdbcValue writeJdbcValue(@Nullable Object value, Class<?> columnType, int sqlType) {
        JdbcValue jdbcValue = this.tryToConvertToJdbcValue(value);
        if (jdbcValue != null) {
            return jdbcValue;
        }
        Object convertedValue = this.writeValue(value, (TypeInformation<?>)ClassTypeInformation.from(columnType));
        if (convertedValue == null || !convertedValue.getClass().isArray()) {
            return JdbcValue.of(convertedValue, JdbcUtil.jdbcTypeFor(sqlType));
        }
        Class<?> componentType = convertedValue.getClass().getComponentType();
        if (componentType != Byte.TYPE && componentType != Byte.class) {
            return JdbcValue.of(this.typeFactory.createArray((Object[])convertedValue), JDBCType.ARRAY);
        }
        if (componentType == Byte.class) {
            convertedValue = ArrayUtil.toPrimitiveByteArray((Byte[])convertedValue);
        }
        return JdbcValue.of(convertedValue, JDBCType.BINARY);
    }

    @Nullable
    private JdbcValue tryToConvertToJdbcValue(@Nullable Object value) {
        if (this.canWriteAsJdbcValue(value)) {
            return (JdbcValue)this.writeValue(value, (TypeInformation<?>)ClassTypeInformation.from(JdbcValue.class));
        }
        return null;
    }

    @Override
    public <T> T mapRow(RelationalPersistentEntity<T> entity, ResultSet resultSet, Object key) {
        return new ReadingContext(new PersistentPropertyPathExtension(this.getMappingContext(), entity), new ResultSetAccessor(resultSet), Identifier.empty(), key).mapRow();
    }

    @Override
    public <T> T mapRow(PersistentPropertyPathExtension path, ResultSet resultSet, Identifier identifier, Object key) {
        return new ReadingContext(path, new ResultSetAccessor(resultSet), identifier, key).mapRow();
    }

    private boolean isSimpleProperty(RelationalPersistentProperty property) {
        return !property.isCollectionLike() && !property.isEntity() && !property.isMap() && !property.isEmbedded();
    }

    private class ReadingContext<T> {
        private final RelationalPersistentEntity<T> entity;
        private final PersistentPropertyPathExtension rootPath;
        private final PersistentPropertyPathExtension path;
        private final Identifier identifier;
        private final Object key;
        private final JdbcPropertyValueProvider propertyValueProvider;
        private final JdbcBackReferencePropertyValueProvider backReferencePropertyValueProvider;

        private ReadingContext(PersistentPropertyPathExtension rootPath, ResultSetAccessor accessor, Identifier identifier, Object key) {
            RelationalPersistentEntity entity = rootPath.getLeafEntity();
            Assert.notNull((Object)entity, (String)"The rootPath must point to an entity.");
            this.entity = entity;
            this.rootPath = rootPath;
            this.path = new PersistentPropertyPathExtension(BasicJdbcConverter.this.getMappingContext(), this.entity);
            this.identifier = identifier;
            this.key = key;
            this.propertyValueProvider = new JdbcPropertyValueProvider(BasicJdbcConverter.this.identifierProcessing, this.path, accessor);
            this.backReferencePropertyValueProvider = new JdbcBackReferencePropertyValueProvider(BasicJdbcConverter.this.identifierProcessing, this.path, accessor);
        }

        private ReadingContext(RelationalPersistentEntity<T> entity, PersistentPropertyPathExtension rootPath, PersistentPropertyPathExtension path, Identifier identifier, Object key, JdbcPropertyValueProvider propertyValueProvider, JdbcBackReferencePropertyValueProvider backReferencePropertyValueProvider) {
            this.entity = entity;
            this.rootPath = rootPath;
            this.path = path;
            this.identifier = identifier;
            this.key = key;
            this.propertyValueProvider = propertyValueProvider;
            this.backReferencePropertyValueProvider = backReferencePropertyValueProvider;
        }

        private <S> ReadingContext<S> extendBy(RelationalPersistentProperty property) {
            return new ReadingContext<T>((RelationalPersistentEntity)BasicJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType()), this.rootPath.extendBy(property), this.path.extendBy(property), this.identifier, this.key, this.propertyValueProvider.extendBy(property), this.backReferencePropertyValueProvider.extendBy(property));
        }

        T mapRow() {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.entity.getIdProperty();
            Object idValue = idProperty == null ? null : this.readFrom(idProperty);
            return this.createInstanceInternal(idValue);
        }

        private T populateProperties(T instance, @Nullable Object idValue) {
            PersistentPropertyAccessor propertyAccessor = BasicJdbcConverter.this.getPropertyAccessor((PersistentEntity)this.entity, instance);
            PreferredConstructor persistenceConstructor = this.entity.getPersistenceConstructor();
            for (RelationalPersistentProperty property : this.entity) {
                if (persistenceConstructor != null && persistenceConstructor.isConstructorParameter((PersistentProperty)property) || BasicJdbcConverter.this.isSimpleProperty(property) && !this.propertyValueProvider.hasProperty(property)) continue;
                Object value = this.readOrLoadProperty(idValue, property);
                propertyAccessor.setProperty((PersistentProperty)property, value);
            }
            return (T)propertyAccessor.getBean();
        }

        @Nullable
        private Object readOrLoadProperty(@Nullable Object id, RelationalPersistentProperty property) {
            if (property.isCollectionLike() && property.isEntity() || property.isMap()) {
                Iterable<Object> allByPath = this.resolveRelation(id, property);
                return property.isMap() ? ITERABLE_OF_ENTRY_TO_MAP_CONVERTER.convert(allByPath) : allByPath;
            }
            if (property.isEmbedded()) {
                return this.readEmbeddedEntityFrom(id, property);
            }
            return this.readFrom(property);
        }

        private Iterable<Object> resolveRelation(@Nullable Object id, RelationalPersistentProperty property) {
            Identifier identifier = id == null ? this.identifier.withPart(this.rootPath.getQualifierColumn(), this.key, Object.class) : Identifier.of((SqlIdentifier)this.rootPath.extendBy(property).getReverseColumnName(), (Object)id, Object.class);
            PersistentPropertyPath propertyPath = this.path.extendBy(property).getRequiredPersistentPropertyPath();
            return BasicJdbcConverter.this.relationResolver.findAllByPath(identifier, (PersistentPropertyPath<? extends RelationalPersistentProperty>)propertyPath);
        }

        @Nullable
        private Object readFrom(RelationalPersistentProperty property) {
            if (property.isEntity()) {
                return this.readEntityFrom(property);
            }
            Object value = this.propertyValueProvider.getPropertyValue(property);
            return value != null ? BasicJdbcConverter.this.readValue(value, property.getTypeInformation()) : null;
        }

        @Nullable
        private Object readEmbeddedEntityFrom(@Nullable Object idValue, RelationalPersistentProperty property) {
            ReadingContext newContext = this.extendBy(property);
            if (this.shouldCreateEmptyEmbeddedInstance(property) || super.hasInstanceValues(idValue)) {
                return super.createInstanceInternal(idValue);
            }
            return null;
        }

        private boolean shouldCreateEmptyEmbeddedInstance(RelationalPersistentProperty property) {
            return property.shouldCreateEmptyEmbedded();
        }

        private boolean hasInstanceValues(@Nullable Object idValue) {
            RelationalPersistentEntity persistentEntity = this.path.getLeafEntity();
            Assert.state((persistentEntity != null ? 1 : 0) != 0, (String)"Entity must not be null");
            for (RelationalPersistentProperty embeddedProperty : persistentEntity) {
                if (embeddedProperty.isQualified() || embeddedProperty.isReference()) {
                    return true;
                }
                Object value = this.readOrLoadProperty(idValue, embeddedProperty);
                if (value == null) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private Object readEntityFrom(RelationalPersistentProperty property) {
            ReadingContext newContext = this.extendBy(property);
            RelationalPersistentEntity entity = (RelationalPersistentEntity)BasicJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType());
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getIdProperty();
            Object idValue = idProperty != null ? super.readFrom(idProperty) : this.backReferencePropertyValueProvider.getPropertyValue(property);
            if (idValue == null) {
                return null;
            }
            return super.createInstanceInternal(idValue);
        }

        private T createInstanceInternal(@Nullable Object idValue) {
            Object instance = BasicJdbcConverter.this.createInstance((PersistentEntity)this.entity, parameter -> {
                String parameterName = parameter.getName();
                Assert.notNull((Object)parameterName, (String)"A constructor parameter name must not be null to be used with Spring Data JDBC");
                RelationalPersistentProperty property = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(parameterName);
                return this.readOrLoadProperty(idValue, property);
            });
            return (T)(this.entity.requiresPropertyPopulation() ? this.populateProperties(instance, idValue) : instance);
        }
    }
}

