/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.util.Optional;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jdbc.core.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.BasicJdbcConverter;
import org.springframework.data.jdbc.core.convert.DefaultJdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public abstract class AbstractJdbcConfiguration {
    @Bean
    public JdbcMappingContext jdbcMappingContext(Optional<NamingStrategy> namingStrategy) {
        JdbcMappingContext mappingContext = new JdbcMappingContext(namingStrategy.orElse(NamingStrategy.INSTANCE));
        mappingContext.setSimpleTypeHolder(this.jdbcCustomConversions().getSimpleTypeHolder());
        return mappingContext;
    }

    @Bean
    public JdbcConverter jdbcConverter(RelationalMappingContext mappingContext, JdbcOperations operations) {
        return new BasicJdbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, this.jdbcCustomConversions(), new DefaultJdbcTypeFactory(operations));
    }

    @Bean
    public JdbcCustomConversions jdbcCustomConversions() {
        return new JdbcCustomConversions();
    }

    @Bean
    public JdbcAggregateTemplate jdbcAggregateTemplate(ApplicationEventPublisher publisher, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations) {
        DefaultDataAccessStrategy dataAccessStrategy = new DefaultDataAccessStrategy(new SqlGeneratorSource(context), context, converter, operations);
        return new JdbcAggregateTemplate(publisher, context, converter, dataAccessStrategy);
    }
}

