/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Array;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.ArrayUtil;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicJdbcConverter
extends BasicRelationalConverter
implements JdbcConverter {
    private static final Logger LOG = LoggerFactory.getLogger(BasicJdbcConverter.class);
    private final JdbcTypeFactory typeFactory;

    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        this(context, JdbcTypeFactory.unsupported());
    }

    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, JdbcTypeFactory typeFactory) {
        super(context);
        Assert.notNull((Object)typeFactory, (String)"JdbcTypeFactory must not be null");
        this.typeFactory = typeFactory;
    }

    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions, JdbcTypeFactory typeFactory) {
        super(context, conversions);
        Assert.notNull((Object)typeFactory, (String)"JdbcTypeFactory must not be null");
        this.typeFactory = typeFactory;
    }

    @Deprecated
    public BasicJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        this(context, conversions, JdbcTypeFactory.unsupported());
    }

    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), type.getType())) {
            return this.getConversionService().convert(value, type.getType());
        }
        if (AggregateReference.class.isAssignableFrom(type.getType())) {
            TypeInformation idType = (TypeInformation)type.getSuperTypeInformation(AggregateReference.class).getTypeArguments().get(1);
            return AggregateReference.to(this.readValue(value, idType));
        }
        if (value instanceof Array) {
            try {
                return this.readValue(((Array)value).getArray(), type);
            }
            catch (SQLException | ConverterNotFoundException e) {
                LOG.info("Failed to extract a value of type %s from an Array. Attempting to use standard conversions.", e);
            }
        }
        return super.readValue(value, type);
    }

    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (AggregateReference.class.isAssignableFrom(value.getClass())) {
            return this.writeValue(((AggregateReference)value).getId(), type);
        }
        return super.writeValue(value, type);
    }

    private boolean canWriteAsJdbcValue(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        if (AggregateReference.class.isAssignableFrom(value.getClass())) {
            return this.canWriteAsJdbcValue(((AggregateReference)value).getId());
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(value.getClass());
        if (persistentEntity != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.canWriteAsJdbcValue(id);
        }
        if (value instanceof JdbcValue) {
            return true;
        }
        Optional customWriteTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        return customWriteTarget.isPresent() && ((Class)customWriteTarget.get()).isAssignableFrom(JdbcValue.class);
    }

    @Override
    public JdbcValue writeJdbcValue(@Nullable Object value, Class<?> columnType, int sqlType) {
        JdbcValue jdbcValue = this.tryToConvertToJdbcValue(value);
        if (jdbcValue != null) {
            return jdbcValue;
        }
        Object convertedValue = this.writeValue(value, (TypeInformation<?>)ClassTypeInformation.from(columnType));
        if (convertedValue == null || !convertedValue.getClass().isArray()) {
            return JdbcValue.of(convertedValue, JdbcUtil.jdbcTypeFor(sqlType));
        }
        Class<?> componentType = convertedValue.getClass().getComponentType();
        if (componentType != Byte.TYPE && componentType != Byte.class) {
            return JdbcValue.of(this.typeFactory.createArray((Object[])convertedValue), JDBCType.ARRAY);
        }
        if (componentType == Byte.class) {
            convertedValue = ArrayUtil.toPrimitiveByteArray((Byte[])convertedValue);
        }
        return JdbcValue.of(convertedValue, JDBCType.BINARY);
    }

    @Nullable
    private JdbcValue tryToConvertToJdbcValue(@Nullable Object value) {
        if (this.canWriteAsJdbcValue(value)) {
            return (JdbcValue)this.writeValue(value, (TypeInformation<?>)ClassTypeInformation.from(JdbcValue.class));
        }
        return null;
    }
}

