/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Optional;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.DefaultJdbcInterpreter;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalEntityDeleteWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityInsertWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityUpdateWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityWriter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.relational.core.mapping.event.AfterSaveEvent;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.relational.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcAggregateTemplate
implements JdbcAggregateOperations {
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    private final RelationalConverter converter;
    private final Interpreter interpreter;
    private final RelationalEntityWriter jdbcEntityWriter;
    private final RelationalEntityDeleteWriter jdbcEntityDeleteWriter;
    private final RelationalEntityInsertWriter jdbcEntityInsertWriter;
    private final RelationalEntityUpdateWriter jdbcEntityUpdateWriter;
    private final DataAccessStrategy accessStrategy;

    public JdbcAggregateTemplate(ApplicationEventPublisher publisher, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = dataAccessStrategy;
        this.jdbcEntityWriter = new RelationalEntityWriter(context);
        this.jdbcEntityInsertWriter = new RelationalEntityInsertWriter(context);
        this.jdbcEntityUpdateWriter = new RelationalEntityUpdateWriter(context);
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.interpreter = new DefaultJdbcInterpreter(context, this.accessStrategy);
    }

    @Override
    public <T> T save(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(instance);
        AggregateChange<T> change = this.createChange(instance);
        return this.store(instance, identifierAccessor, change, persistentEntity);
    }

    @Override
    public <T> T insert(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(instance);
        AggregateChange<T> change = this.createInsertChange(instance);
        return this.store(instance, identifierAccessor, change, persistentEntity);
    }

    @Override
    public <T> T update(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(instance);
        AggregateChange<T> change = this.createUpdateChange(instance);
        return this.store(instance, identifierAccessor, change, persistentEntity);
    }

    @Override
    public long count(Class<?> domainType) {
        return this.accessStrategy.count(domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        T entity = this.accessStrategy.findById(id, domainType);
        if (entity != null) {
            this.publishAfterLoad(id, entity);
        }
        return entity;
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return this.accessStrategy.existsById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        Iterable<T> all = this.accessStrategy.findAll(domainType);
        this.publishAfterLoad(all);
        return all;
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Iterable<T> allById = this.accessStrategy.findAllById(ids, domainType);
        this.publishAfterLoad(allById);
        return allById;
    }

    public <S> void delete(S aggregateRoot, Class<S> domainType) {
        IdentifierAccessor identifierAccessor = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdentifierAccessor(aggregateRoot);
        this.deleteTree(identifierAccessor.getRequiredIdentifier(), aggregateRoot, domainType);
    }

    public <S> void deleteById(Object id, Class<S> domainType) {
        this.deleteTree(id, null, domainType);
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        AggregateChange<?> change = this.createDeletingChange(domainType);
        change.executeWith(this.interpreter, this.context, this.converter);
    }

    private <T> T store(T instance, IdentifierAccessor identifierAccessor, AggregateChange<T> change, RelationalPersistentEntity<?> persistentEntity) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(Identifier.ofNullable((Object)identifierAccessor.getIdentifier()), instance, change));
        change.executeWith(this.interpreter, this.context, this.converter);
        Object identifier = persistentEntity.getIdentifierAccessor(change.getEntity()).getIdentifier();
        Assert.notNull((Object)identifier, (String)"After saving the identifier must not be null");
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(Identifier.of((Object)identifier), change.getEntity(), change));
        return (T)change.getEntity();
    }

    private void deleteTree(Object id, @Nullable Object entity, Class<?> domainType) {
        AggregateChange<?> change = this.createDeletingChange(id, entity, domainType);
        Identifier.Specified specifiedId = Identifier.of((Object)id);
        Optional<Object> optionalEntity = Optional.ofNullable(entity);
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(specifiedId, optionalEntity, change));
        change.executeWith(this.interpreter, this.context, this.converter);
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(specifiedId, optionalEntity, change));
    }

    private <T> AggregateChange<T> createChange(T instance) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.SAVE, instance.getClass(), instance);
        this.jdbcEntityWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> AggregateChange<T> createInsertChange(T instance) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.SAVE, instance.getClass(), instance);
        this.jdbcEntityInsertWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> AggregateChange<T> createUpdateChange(T instance) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.SAVE, instance.getClass(), instance);
        this.jdbcEntityUpdateWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private AggregateChange<?> createDeletingChange(Object id, @Nullable Object entity, Class<?> domainType) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.DELETE, domainType, entity);
        this.jdbcEntityDeleteWriter.write(id, aggregateChange);
        return aggregateChange;
    }

    private AggregateChange<?> createDeletingChange(Class<?> domainType) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.DELETE, domainType, null);
        this.jdbcEntityDeleteWriter.write(null, aggregateChange);
        return aggregateChange;
    }

    private <T> void publishAfterLoad(Iterable<T> all) {
        for (T e : all) {
            RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(e.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(e);
            this.publishAfterLoad(identifierAccessor.getRequiredIdentifier(), e);
        }
    }

    private <T> void publishAfterLoad(Object id, T entity) {
        this.publisher.publishEvent((ApplicationEvent)new AfterLoadEvent(Identifier.of((Object)id), entity));
    }
}

